/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model;

import com.dedicatedcode.reitti.model.Sort;

public class PageRequest {
    private final int page;
    private final int size;
    private final Sort sort;

    public PageRequest(int page, int size) {
        this(page, size, null);
    }

    public PageRequest(int page, int size, Sort sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageSize() {
        return this.size;
    }

    public long getOffset() {
        return (long)this.page * (long)this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public static PageRequest of(int page, int size) {
        return new PageRequest(page, size);
    }

    public static PageRequest of(int page, int size, Sort sort) {
        return new PageRequest(page, size, sort);
    }
}

