/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.geo;

import com.dedicatedcode.reitti.model.geo.GeoUtils;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;

public record GeoPoint(double latitude, double longitude) implements Serializable
{
    private final double latitude;
    private final double longitude;

    public GeoPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static GeoPoint from(Point point) {
        return new GeoPoint(point.getY(), point.getX());
    }

    public static GeoPoint from(double latitude, double longitude) {
        return new GeoPoint(latitude, longitude);
    }

    public boolean near(GeoPoint point) {
        return GeoUtils.distanceInMeters((GeoPoint)this, (GeoPoint)point) < 150.0;
    }

    @Override
    public String toString() {
        return "[lat,long]=[" + this.latitude + "," + this.longitude + "] -> (https://www.google.com/maps/search/?api=1&query=" + this.latitude + "," + this.longitude + ")";
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }
}

