/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.geo;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeoUtils {
    private static final double EARTH_RADIUS = 6371000.0;

    private GeoUtils() {
    }

    public static double distanceInMeters(double lat1, double lon1, double lat2, double lon2) {
        double latDistance = Math.toRadians(lat2 - lat1);
        double lonDistance = Math.toRadians(lon2 - lon1);
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6371000.0 * c;
    }

    public static double distanceInMeters(GeoPoint p1, GeoPoint p2) {
        return GeoUtils.distanceInMeters((double)p1.latitude(), (double)p1.longitude(), (double)p2.latitude(), (double)p2.longitude());
    }

    public static double distanceInMeters(LocationPoint p1, LocationPoint p2) {
        return GeoUtils.distanceInMeters((double)p1.getLatitude(), (double)p1.getLongitude(), (double)p2.getLatitude(), (double)p2.getLongitude());
    }

    public static double distanceInMeters(RawLocationPoint p1, RawLocationPoint p2) {
        return GeoUtils.distanceInMeters((double)p1.getLatitude(), (double)p1.getLongitude(), (double)p2.getLatitude(), (double)p2.getLongitude());
    }

    public static double metersToDegreesAtPosition(double meters, double latitude) {
        return meters / (111320.0 * Math.cos(Math.toRadians(latitude)));
    }

    public static double calculateTripDistance(List<RawLocationPoint> points) {
        if (points.size() < 2) {
            return 0.0;
        }
        ArrayList<RawLocationPoint> tmp = new ArrayList<RawLocationPoint>(points);
        tmp.sort(Comparator.comparing(RawLocationPoint::getTimestamp));
        double totalDistance = 0.0;
        for (int i = 0; i < tmp.size() - 1; ++i) {
            RawLocationPoint p1 = (RawLocationPoint)tmp.get(i);
            RawLocationPoint p2 = (RawLocationPoint)tmp.get(i + 1);
            totalDistance += GeoUtils.distanceInMeters((RawLocationPoint)p1, (RawLocationPoint)p2);
        }
        return totalDistance;
    }

    public static GeoPoint calculatePolygonCentroid(List<GeoPoint> polygon) {
        if (polygon == null || polygon.isEmpty()) {
            throw new IllegalArgumentException("Polygon cannot be null or empty");
        }
        List uniquePoints = GeoUtils.removeDuplicates(polygon);
        double avgLat = uniquePoints.stream().mapToDouble(GeoPoint::latitude).average().orElse(0.0);
        double avgLng = uniquePoints.stream().mapToDouble(GeoPoint::longitude).average().orElse(0.0);
        return new GeoPoint(avgLat, avgLng);
    }

    public static double calculatePolygonArea(List<GeoPoint> polygon) {
        if (polygon == null) {
            throw new IllegalArgumentException("Polygon cannot be null");
        }
        List uniquePoints = GeoUtils.removeDuplicates(polygon);
        if (uniquePoints.size() < 3) {
            throw new IllegalArgumentException("Polygon must contain at least three distinct points");
        }
        double[] xs = new double[uniquePoints.size()];
        double[] ys = new double[uniquePoints.size()];
        for (int i = 0; i < uniquePoints.size(); ++i) {
            double lonMeters;
            GeoPoint p = (GeoPoint)uniquePoints.get(i);
            double latMeters = p.latitude() * 111320.0;
            xs[i] = lonMeters = p.longitude() * 111320.0 * Math.cos(Math.toRadians(p.latitude()));
            ys[i] = latMeters;
        }
        double sum = 0.0;
        int n = uniquePoints.size();
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n;
            sum += xs[i] * ys[j] - xs[j] * ys[i];
        }
        return Math.abs(sum) / 2.0;
    }

    private static List<GeoPoint> removeDuplicates(List<GeoPoint> polygon) {
        ArrayList<GeoPoint> uniquePoints = new ArrayList<GeoPoint>();
        for (GeoPoint point : polygon) {
            boolean isDuplicate = uniquePoints.stream().anyMatch(existing -> Math.abs(existing.latitude() - point.latitude()) < 1.0E-6 && Math.abs(existing.longitude() - point.longitude()) < 1.0E-6);
            if (isDuplicate) continue;
            uniquePoints.add(point);
        }
        return uniquePoints;
    }
}

