/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.geo;

import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;

public class SignificantPlace
implements Serializable {
    private final Long id;
    private final String name;
    private final String address;
    private final String city;
    private final String countryCode;
    private final Double latitudeCentroid;
    private final Double longitudeCentroid;
    private final List<GeoPoint> polygon;
    private final PlaceType type;
    private final ZoneId timezone;
    private final boolean geocoded;
    private final Long version;

    public static SignificantPlace create(Double latitude, Double longitude) {
        return new SignificantPlace(null, null, null, null, null, latitude, longitude, null, PlaceType.OTHER, ZoneId.systemDefault(), false, Long.valueOf(1L));
    }

    public SignificantPlace(Long id, String name, String address, String city, String countryCode, Double latitudeCentroid, Double longitudeCentroid, List<GeoPoint> polygon, PlaceType type, ZoneId timezone, boolean geocoded, Long version) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.city = city;
        this.countryCode = countryCode;
        this.latitudeCentroid = latitudeCentroid;
        this.longitudeCentroid = longitudeCentroid;
        this.polygon = polygon;
        this.type = type;
        this.timezone = timezone;
        this.geocoded = geocoded;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Double getLatitudeCentroid() {
        return this.latitudeCentroid;
    }

    public Double getLongitudeCentroid() {
        return this.longitudeCentroid;
    }

    public List<GeoPoint> getPolygon() {
        return this.polygon;
    }

    public PlaceType getType() {
        return this.type;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public boolean isGeocoded() {
        return this.geocoded;
    }

    public Long getVersion() {
        return this.version;
    }

    public SignificantPlace withGeocoded(boolean geocoded) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, geocoded, this.version);
    }

    public SignificantPlace withName(String name) {
        return new SignificantPlace(this.id, name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withAddress(String address) {
        return new SignificantPlace(this.id, this.name, address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withCountryCode(String countryCode) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withType(PlaceType type) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withId(Long id) {
        return new SignificantPlace(id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withTimezone(ZoneId timezone) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, timezone, this.geocoded, this.version);
    }

    public SignificantPlace withCity(String city) {
        return new SignificantPlace(this.id, this.name, this.address, city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withPolygon(List<GeoPoint> polygon) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, this.longitudeCentroid, polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withLatitudeCentroid(Double latitudeCentroid) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, latitudeCentroid, this.longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public SignificantPlace withLongitudeCentroid(Double longitudeCentroid) {
        return new SignificantPlace(this.id, this.name, this.address, this.city, this.countryCode, this.latitudeCentroid, longitudeCentroid, this.polygon, this.type, this.timezone, this.geocoded, this.version);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignificantPlace that = (SignificantPlace)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "SignificantPlace{id=" + this.id + ", name='" + this.name + "'}";
    }

    public String getCity() {
        return this.city;
    }
}

