/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.geo;

import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.TransportMode;
import java.time.Instant;
import java.util.Objects;

public class Trip {
    private final Long id;
    private final Instant startTime;
    private final Instant endTime;
    private final Long durationSeconds;
    private final Double estimatedDistanceMeters;
    private final Double travelledDistanceMeters;
    private final TransportMode transportModeInferred;
    private final ProcessedVisit startVisit;
    private final ProcessedVisit endVisit;
    private final Long version;

    public Trip(Instant startTime, Instant endTime, Long durationSeconds, Double estimatedDistanceMeters, Double travelledDistanceMeters, TransportMode transportModeInferred, ProcessedVisit startVisit, ProcessedVisit endVisit) {
        this(null, startTime, endTime, durationSeconds, estimatedDistanceMeters, travelledDistanceMeters, transportModeInferred, startVisit, endVisit, Long.valueOf(1L));
    }

    public Trip(Long id, Instant startTime, Instant endTime, Long durationSeconds, Double estimatedDistanceMeters, Double travelledDistanceMeters, TransportMode transportModeInferred, ProcessedVisit startVisit, ProcessedVisit endVisit, Long version) {
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.durationSeconds = durationSeconds;
        this.estimatedDistanceMeters = estimatedDistanceMeters;
        this.travelledDistanceMeters = travelledDistanceMeters;
        this.transportModeInferred = transportModeInferred;
        this.startVisit = startVisit;
        this.endVisit = endVisit;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Long getDurationSeconds() {
        return this.durationSeconds;
    }

    public Double getEstimatedDistanceMeters() {
        return this.estimatedDistanceMeters;
    }

    public Double getTravelledDistanceMeters() {
        return this.travelledDistanceMeters;
    }

    public TransportMode getTransportModeInferred() {
        return this.transportModeInferred;
    }

    public ProcessedVisit getStartVisit() {
        return this.startVisit;
    }

    public ProcessedVisit getEndVisit() {
        return this.endVisit;
    }

    public Long getVersion() {
        return this.version;
    }

    public Trip withId(Long id) {
        return new Trip(id, this.startTime, this.endTime, this.durationSeconds, this.estimatedDistanceMeters, this.travelledDistanceMeters, this.transportModeInferred, this.startVisit, this.endVisit, this.version);
    }

    public Trip withTransportMode(TransportMode mode) {
        return new Trip(this.id, this.startTime, this.endTime, this.durationSeconds, this.estimatedDistanceMeters, this.travelledDistanceMeters, mode, this.startVisit, this.endVisit, this.version);
    }

    public Trip withVersion(long version) {
        return new Trip(this.id, this.startTime, this.endTime, this.durationSeconds, this.estimatedDistanceMeters, this.travelledDistanceMeters, this.transportModeInferred, this.startVisit, this.endVisit, Long.valueOf(version));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trip trip = (Trip)o;
        return Objects.equals(this.id, trip.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

