/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.geo;

import java.time.Instant;
import java.util.Objects;

public class Visit {
    private final Long id;
    private final Double longitude;
    private final Double latitude;
    private final Instant startTime;
    private final Instant endTime;
    private final Long durationSeconds;
    private final boolean processed;
    private final Long version;

    public Visit(Double longitude, Double latitude, Instant startTime, Instant endTime, Long durationSeconds, boolean processed) {
        this(null, longitude, latitude, startTime, endTime, durationSeconds, processed, Long.valueOf(1L));
    }

    public Visit(Long id, Double longitude, Double latitude, Instant startTime, Instant endTime, Long durationSeconds, boolean processed, Long version) {
        this.id = id;
        this.longitude = longitude;
        this.latitude = latitude;
        this.startTime = startTime;
        this.endTime = endTime;
        this.durationSeconds = durationSeconds;
        this.processed = processed;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Long getDurationSeconds() {
        return this.durationSeconds;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public Long getVersion() {
        return this.version;
    }

    public Visit withId(Long id) {
        return new Visit(id, this.longitude, this.latitude, this.startTime, this.endTime, this.durationSeconds, this.processed, this.version);
    }

    public Visit withVersion(long version) {
        return new Visit(this.id, this.longitude, this.latitude, this.startTime, this.endTime, this.durationSeconds, this.processed, Long.valueOf(version));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Visit visit = (Visit)o;
        return Objects.equals(this.id, visit.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Visit{latitude=" + this.latitude + ", id=" + this.id + ", longitude=" + this.longitude + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ", durationSeconds=" + this.durationSeconds + ", processed=" + this.processed + ", version=" + this.version + "}";
    }
}

