/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.integration;

import com.dedicatedcode.reitti.model.integration.ReittiIntegration;
import java.time.LocalDateTime;
import java.util.Optional;

public class ReittiIntegration {
    private final Long id;
    private final String url;
    private final String token;
    private final boolean enabled;
    private final Status status;
    private final LocalDateTime createdAt;
    private final LocalDateTime updatedAt;
    private final LocalDateTime lastUsed;
    private final Long version;
    private final String lastMessage;
    private final String color;

    public ReittiIntegration(Long id, String url, String token, boolean enabled, Status status, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime lastUsed, Long version, String lastMessage, String color) {
        this.id = id;
        this.url = url;
        this.token = token;
        this.enabled = enabled;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastUsed = lastUsed;
        this.version = version;
        this.lastMessage = lastMessage;
        this.color = color;
    }

    public static ReittiIntegration create(String url, String token, boolean enabled, String color) {
        return new ReittiIntegration(Long.valueOf(-1L), url, token, enabled, enabled ? Status.ACTIVE : Status.RECOVERABLE, LocalDateTime.now(), null, null, Long.valueOf(1L), null, color);
    }

    public Long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Status getStatus() {
        return this.status;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Optional<LocalDateTime> getLastUsed() {
        return Optional.ofNullable(this.lastUsed);
    }

    public Long getVersion() {
        return this.version;
    }

    public Optional<String> getLastMessage() {
        return Optional.ofNullable(this.lastMessage);
    }

    public String getColor() {
        return this.color;
    }

    public ReittiIntegration withEnabled(boolean enabled) {
        return new ReittiIntegration(this.id, this.url, this.token, enabled, this.status, this.createdAt, this.updatedAt, this.lastUsed, this.version, this.lastMessage, this.color);
    }

    public ReittiIntegration withLastUsed(LocalDateTime lastUsed) {
        return new ReittiIntegration(this.id, this.url, this.token, this.enabled, this.status, this.createdAt, this.updatedAt, lastUsed, this.version, this.lastMessage, this.color);
    }

    public ReittiIntegration withStatus(Status status) {
        return new ReittiIntegration(this.id, this.url, this.token, this.enabled, status, this.createdAt, this.updatedAt, this.lastUsed, this.version, this.lastMessage, this.color);
    }

    public String toString() {
        return "ReittiIntegration{id=" + this.id + ", url='" + this.url + "', token='" + this.token + "', enabled=" + this.enabled + ", status=" + String.valueOf(this.status) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", lastUsed=" + String.valueOf(this.lastUsed) + ", version=" + this.version + ", lastMessage='" + this.lastMessage + "', color='" + this.color + "'}";
    }
}

