/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.HeaderType;
import java.io.Serializable;
import java.time.Instant;

public class Memory
implements Serializable {
    private final Long id;
    private final String title;
    private final String description;
    private final Instant startDate;
    private final Instant endDate;
    private final HeaderType headerType;
    private final String headerImageUrl;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Long version;

    public Memory(String title, String description, Instant startDate, Instant endDate, HeaderType headerType, String headerImageUrl) {
        this(null, title, description, startDate, endDate, headerType, headerImageUrl, Instant.now(), Instant.now(), Long.valueOf(1L));
    }

    public Memory(Long id, String title, String description, Instant startDate, Instant endDate, HeaderType headerType, String headerImageUrl, Instant createdAt, Instant updatedAt, Long version) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.startDate = startDate;
        this.endDate = endDate;
        this.headerType = headerType;
        this.headerImageUrl = headerImageUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public String getHeaderImageUrl() {
        return this.headerImageUrl;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getVersion() {
        return this.version;
    }

    public Memory withId(Long id) {
        return new Memory(id, this.title, this.description, this.startDate, this.endDate, this.headerType, this.headerImageUrl, this.createdAt, this.updatedAt, this.version);
    }

    public Memory withTitle(String title) {
        return new Memory(this.id, title, this.description, this.startDate, this.endDate, this.headerType, this.headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withDescription(String description) {
        return new Memory(this.id, this.title, description, this.startDate, this.endDate, this.headerType, this.headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withStartDate(Instant startDate) {
        return new Memory(this.id, this.title, this.description, startDate, this.endDate, this.headerType, this.headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withEndDate(Instant endDate) {
        return new Memory(this.id, this.title, this.description, this.startDate, endDate, this.headerType, this.headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withHeaderType(HeaderType headerType) {
        return new Memory(this.id, this.title, this.description, this.startDate, this.endDate, headerType, this.headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withHeaderImageUrl(String headerImageUrl) {
        return new Memory(this.id, this.title, this.description, this.startDate, this.endDate, this.headerType, headerImageUrl, this.createdAt, Instant.now(), this.version);
    }

    public Memory withVersion(Long version) {
        return new Memory(this.id, this.title, this.description, this.startDate, this.endDate, this.headerType, this.headerImageUrl, this.createdAt, this.updatedAt, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Memory memory = (Memory)o;
        return this.id != null ? this.id.equals(memory.id) : memory.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Memory{id=" + this.id + ", title='" + this.title + "', description='" + this.description + "', startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", headerType=" + String.valueOf(this.headerType) + ", headerImageUrl='" + this.headerImageUrl + "', createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", version=" + this.version + "}";
    }
}

