/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import java.io.Serializable;

public class MemoryBlock
implements Serializable {
    private final Long id;
    private final Long memoryId;
    private final BlockType blockType;
    private final Integer position;
    private final Long version;

    public MemoryBlock(Long memoryId, BlockType blockType, Integer position) {
        this(null, memoryId, blockType, position, Long.valueOf(1L));
    }

    public MemoryBlock(Long id, Long memoryId, BlockType blockType, Integer position, Long version) {
        this.id = id;
        this.memoryId = memoryId;
        this.blockType = blockType;
        this.position = position;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public Long getMemoryId() {
        return this.memoryId;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Long getVersion() {
        return this.version;
    }

    public MemoryBlock withId(Long id) {
        return new MemoryBlock(id, this.memoryId, this.blockType, this.position, this.version);
    }

    public MemoryBlock withPosition(Integer position) {
        return new MemoryBlock(this.id, this.memoryId, this.blockType, position, this.version);
    }

    public MemoryBlock withVersion(Long version) {
        return new MemoryBlock(this.id, this.memoryId, this.blockType, this.position, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryBlock that = (MemoryBlock)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "MemoryBlock{id=" + this.id + ", memoryId=" + this.memoryId + ", blockType=" + String.valueOf(this.blockType) + ", position=" + this.position + ", version=" + this.version + "}";
    }
}

