/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlockImageGallery;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class MemoryBlockImageGallery
implements MemoryBlockPart,
Serializable {
    private final Long blockId;
    private final List<GalleryImage> images;

    public MemoryBlockImageGallery(Long blockId, List<GalleryImage> images) {
        this.blockId = blockId;
        this.images = images != null ? List.copyOf(images) : List.of();
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public List<GalleryImage> getImages() {
        return this.images;
    }

    public BlockType getType() {
        return BlockType.IMAGE_GALLERY;
    }

    public MemoryBlockImageGallery withImages(List<GalleryImage> images) {
        return new MemoryBlockImageGallery(this.blockId, images);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryBlockImageGallery that = (MemoryBlockImageGallery)o;
        return Objects.equals(this.blockId, that.blockId);
    }

    public int hashCode() {
        return this.blockId != null ? this.blockId.hashCode() : 0;
    }

    public String toString() {
        return "MemoryBlockImageGallery{blockId=" + this.blockId + ", images=" + String.valueOf(this.images) + "}";
    }
}

