/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import java.io.Serializable;

public class MemoryBlockText
implements MemoryBlockPart,
Serializable {
    private final Long blockId;
    private final String headline;
    private final String content;

    public MemoryBlockText(Long blockId, String headline, String content) {
        this.blockId = blockId;
        this.headline = headline;
        this.content = content;
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public String getHeadline() {
        return this.headline;
    }

    public String getContent() {
        return this.content;
    }

    public BlockType getType() {
        return BlockType.TEXT;
    }

    public MemoryBlockText withHeadline(String headline) {
        return new MemoryBlockText(this.blockId, headline, this.content);
    }

    public MemoryBlockText withContent(String content) {
        return new MemoryBlockText(this.blockId, this.headline, content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryBlockText that = (MemoryBlockText)o;
        return this.blockId != null ? this.blockId.equals(that.blockId) : that.blockId == null;
    }

    public int hashCode() {
        return this.blockId != null ? this.blockId.hashCode() : 0;
    }

    public String toString() {
        return "MemoryBlockText{blockId=" + this.blockId + ", headline='" + this.headline + "', content='" + this.content + "'}";
    }
}

