/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class MemoryClusterBlock
implements MemoryBlockPart,
Serializable {
    private final Long blockId;
    private final List<Long> partIds;
    private final String title;
    private final String description;
    private final BlockType type;

    public MemoryClusterBlock(Long blockId, List<Long> partIds, String title, String description, BlockType type) {
        this.blockId = blockId;
        this.partIds = partIds != null ? List.copyOf(partIds) : List.of();
        this.title = title;
        this.description = description;
        this.type = type;
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public List<Long> getPartIds() {
        return this.partIds;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public BlockType getType() {
        return this.type;
    }

    public MemoryClusterBlock withPartIds(List<Long> partIds) {
        return new MemoryClusterBlock(this.blockId, partIds, this.title, this.description, this.type);
    }

    public MemoryClusterBlock withTitle(String title) {
        return new MemoryClusterBlock(this.blockId, this.partIds, title, this.description, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryClusterBlock that = (MemoryClusterBlock)o;
        return Objects.equals(this.blockId, that.blockId);
    }

    public int hashCode() {
        return this.blockId != null ? this.blockId.hashCode() : 0;
    }

    public String toString() {
        return "MemoryClusterBlock{blockId=" + this.blockId + ", partIds=" + String.valueOf(this.partIds) + ", title='" + this.title + "', description='" + this.description + "'}";
    }
}

