/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.HeaderType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.service.TimeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class MemoryDTO {
    private final Long id;
    private final String title;
    private final String description;
    private final LocalDateTime startDate;
    private final LocalDateTime endDate;
    private final HeaderType headerType;
    private final String headerImageUrl;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Long version;
    private final ZoneId timezone;

    public MemoryDTO(Memory memory, ZoneId timezone) {
        this.id = memory.getId();
        this.title = memory.getTitle();
        this.description = memory.getDescription();
        this.startDate = TimeUtil.adjustInstant((Instant)memory.getStartDate(), (ZoneId)timezone);
        this.endDate = TimeUtil.adjustInstant((Instant)memory.getEndDate(), (ZoneId)timezone);
        this.headerType = memory.getHeaderType();
        this.headerImageUrl = memory.getHeaderImageUrl();
        this.createdAt = memory.getCreatedAt();
        this.updatedAt = memory.getUpdatedAt();
        this.version = memory.getVersion();
        this.timezone = timezone;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public String getHeaderImageUrl() {
        return this.headerImageUrl;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getVersion() {
        return this.version;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public Instant getStartDateAsInstant() {
        return this.startDate.atZone(this.timezone).toInstant();
    }

    public Instant getEndDateAsInstant() {
        return this.endDate.atZone(this.timezone).toInstant();
    }
}

