/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.memory.MemoryVisit;
import java.time.Duration;
import java.time.Instant;

public class MemoryTrip {
    private final Long id;
    private final boolean connected;
    private final MemoryVisit startVisit;
    private final MemoryVisit endVisit;
    private final Instant startTime;
    private final Instant endTime;

    public static MemoryTrip create(Trip trip, MemoryVisit startVisit, MemoryVisit endVisit) {
        return new MemoryTrip(null, true, startVisit, endVisit, trip.getStartTime(), trip.getEndTime());
    }

    public MemoryTrip(Long id, boolean connected, MemoryVisit startVisit, MemoryVisit endVisit, Instant startTime, Instant endTime) {
        this.id = id;
        this.connected = connected;
        this.startVisit = startVisit;
        this.endVisit = endVisit;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public long getDurationSeconds() {
        return Duration.between(this.startTime, this.endTime).getSeconds();
    }

    public MemoryVisit getStartVisit() {
        return this.startVisit;
    }

    public MemoryVisit getEndVisit() {
        return this.endVisit;
    }

    public MemoryTrip withId(Long generatedId) {
        return new MemoryTrip(generatedId, this.connected, this.startVisit, this.endVisit, this.startTime, this.endTime);
    }
}

