/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.memory.MemoryTrip;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class MemoryTripClusterBlockDTO
implements MemoryBlockPart,
Serializable {
    private final MemoryClusterBlock clusterBlock;
    private final List<MemoryTrip> trips;
    private final String rawLocationPointsUrl;
    private final LocalDateTime adjustedStartTime;
    private final LocalDateTime adjustedEndTime;
    private final Long completeDuration;
    private final Long movingDuration;

    public MemoryTripClusterBlockDTO(MemoryClusterBlock clusterBlock, List<MemoryTrip> trips, String rawLocationPointsUrl, LocalDateTime adjustedStartTime, LocalDateTime adjustedEndTime, Long completeDuration, Long movingDuration) {
        this.clusterBlock = clusterBlock;
        this.trips = trips != null ? List.copyOf(trips) : List.of();
        this.rawLocationPointsUrl = rawLocationPointsUrl;
        this.adjustedStartTime = adjustedStartTime;
        this.adjustedEndTime = adjustedEndTime;
        this.completeDuration = completeDuration;
        this.movingDuration = movingDuration;
    }

    public MemoryClusterBlock getClusterBlock() {
        return this.clusterBlock;
    }

    public List<MemoryTrip> getTrips() {
        return this.trips;
    }

    public Long getBlockId() {
        return this.clusterBlock.getBlockId();
    }

    public String getTitle() {
        return this.clusterBlock.getTitle();
    }

    public String getDescription() {
        return this.clusterBlock.getDescription();
    }

    public Long getCompleteDuration() {
        return this.completeDuration;
    }

    public Long getMovingDuration() {
        return this.movingDuration;
    }

    public Instant getCombinedStartTime() {
        if (this.trips == null || this.trips.isEmpty()) {
            return null;
        }
        return this.trips.stream().map(MemoryTrip::getStartTime).min(Instant::compareTo).orElse(null);
    }

    public Instant getCombinedEndTime() {
        if (this.trips == null || this.trips.isEmpty()) {
            return null;
        }
        return this.trips.stream().map(MemoryTrip::getEndTime).max(Instant::compareTo).orElse(null);
    }

    public Long getCombinedDurationSeconds() {
        if (this.trips == null || this.trips.isEmpty()) {
            return 0L;
        }
        return this.trips.stream().mapToLong(MemoryTrip::getDurationSeconds).sum();
    }

    public List<String> getCombinedStartPlaces() {
        if (this.trips == null || this.trips.isEmpty()) {
            return List.of();
        }
        return this.trips.stream().map(trip -> trip.getStartVisit().getName()).toList();
    }

    public List<String> getCombinedEndPlaces() {
        if (this.trips == null || this.trips.isEmpty()) {
            return List.of();
        }
        return this.trips.stream().map(trip -> trip.getEndVisit().getName()).toList();
    }

    public String getRawLocationPointsUrl() {
        return this.rawLocationPointsUrl;
    }

    public LocalDateTime getAdjustedEndTime() {
        return this.adjustedEndTime;
    }

    public LocalDateTime getAdjustedStartTime() {
        return this.adjustedStartTime;
    }

    public BlockType getType() {
        return BlockType.CLUSTER_TRIP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryTripClusterBlockDTO that = (MemoryTripClusterBlockDTO)o;
        return Objects.equals(this.clusterBlock, that.clusterBlock);
    }

    public int hashCode() {
        return this.clusterBlock != null ? this.clusterBlock.hashCode() : 0;
    }

    public String toString() {
        return "MemoryClusterBlockDTO{clusterBlock=" + String.valueOf(this.clusterBlock) + ", trips=" + String.valueOf(this.trips) + "}";
    }
}

