/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.memory;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.memory.MemoryVisit;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class MemoryVisitClusterBlockDTO
implements MemoryBlockPart,
Serializable {
    private final MemoryClusterBlock clusterBlock;
    private final List<MemoryVisit> visits;
    private final String rawLocationPointsUrl;
    private final LocalDateTime adjustedStartTime;
    private final LocalDateTime adjustedEndTime;
    private final Long completeDuration;

    public MemoryVisitClusterBlockDTO(MemoryClusterBlock clusterBlock, List<MemoryVisit> visits, String rawLocationPointsUrl, LocalDateTime adjustedStartTime, LocalDateTime adjustedEndTime, Long completeDuration) {
        this.clusterBlock = clusterBlock;
        this.visits = visits != null ? List.copyOf(visits) : List.of();
        this.rawLocationPointsUrl = rawLocationPointsUrl;
        this.adjustedStartTime = adjustedStartTime;
        this.adjustedEndTime = adjustedEndTime;
        this.completeDuration = completeDuration;
    }

    public MemoryClusterBlock getClusterBlock() {
        return this.clusterBlock;
    }

    public List<MemoryVisit> getVisits() {
        return this.visits;
    }

    public Long getBlockId() {
        return this.clusterBlock.getBlockId();
    }

    public String getTitle() {
        return this.clusterBlock.getTitle();
    }

    public String getDescription() {
        return this.clusterBlock.getDescription();
    }

    public Long getCompleteDuration() {
        return this.completeDuration;
    }

    public Instant getCombinedStartTime() {
        if (this.visits == null || this.visits.isEmpty()) {
            return null;
        }
        return this.visits.stream().map(MemoryVisit::getStartTime).min(Instant::compareTo).orElse(null);
    }

    public Instant getCombinedEndTime() {
        if (this.visits == null || this.visits.isEmpty()) {
            return null;
        }
        return this.visits.stream().map(MemoryVisit::getEndTime).max(Instant::compareTo).orElse(null);
    }

    public Long getCombinedDurationSeconds() {
        if (this.visits == null || this.visits.isEmpty()) {
            return 0L;
        }
        return this.visits.stream().mapToLong(MemoryVisit::getDurationSeconds).sum();
    }

    public String getRawLocationPointsUrl() {
        return this.rawLocationPointsUrl;
    }

    public LocalDateTime getAdjustedEndTime() {
        return this.adjustedEndTime;
    }

    public LocalDateTime getAdjustedStartTime() {
        return this.adjustedStartTime;
    }

    public BlockType getType() {
        return BlockType.CLUSTER_VISIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryVisitClusterBlockDTO that = (MemoryVisitClusterBlockDTO)o;
        return Objects.equals(this.clusterBlock, that.clusterBlock);
    }

    public int hashCode() {
        return this.clusterBlock != null ? this.clusterBlock.hashCode() : 0;
    }

    public String toString() {
        return "MemoryClusterBlockDTO{clusterBlock=" + String.valueOf(this.clusterBlock) + ", Visits=" + String.valueOf(this.visits) + "}";
    }
}

