/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.processing;

import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import java.io.Serializable;
import java.time.Instant;

public class DetectionParameter
implements Serializable {
    private final Long id;
    private final VisitDetection visitDetection;
    private final VisitMerging visitMerging;
    private final LocationDensity locationDensity;
    private final Instant validSince;
    private final RecalculationState recalculationState;

    public DetectionParameter(Long id, VisitDetection visitDetection, VisitMerging visitMerging, LocationDensity locationDensity, Instant validSince, RecalculationState recalculationState) {
        this.id = id;
        this.visitDetection = visitDetection;
        this.visitMerging = visitMerging;
        this.locationDensity = locationDensity;
        this.validSince = validSince;
        this.recalculationState = recalculationState;
    }

    public Long getId() {
        return this.id;
    }

    public VisitDetection getVisitDetection() {
        return this.visitDetection;
    }

    public VisitMerging getVisitMerging() {
        return this.visitMerging;
    }

    public LocationDensity getLocationDensity() {
        return this.locationDensity;
    }

    public Instant getValidSince() {
        return this.validSince;
    }

    public RecalculationState getRecalculationState() {
        return this.recalculationState;
    }

    public DetectionParameter withRecalculationState(RecalculationState recalculationState) {
        return new DetectionParameter(this.id, this.visitDetection, this.visitMerging, this.locationDensity, this.validSince, recalculationState);
    }

    public DetectionParameter withLocationDensity(LocationDensity locationDensity) {
        return new DetectionParameter(this.id, this.visitDetection, this.visitMerging, locationDensity, this.validSince, this.recalculationState);
    }
}

