/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.security;

import com.dedicatedcode.reitti.model.security.User;
import java.time.Instant;
import java.util.UUID;

public class ApiToken {
    private final Long id;
    private final String token;
    private final User user;
    private final String name;
    private final Instant createdAt;
    private final Instant lastUsedAt;

    public ApiToken(User user, String name) {
        this(null, null, user, name, null, null);
    }

    public ApiToken(Long id, String token, User user, String name, Instant createdAt, Instant lastUsedAt) {
        this.id = id;
        this.token = token != null ? token : UUID.randomUUID().toString();
        this.user = user;
        this.name = name;
        this.createdAt = createdAt != null ? createdAt : Instant.now();
        this.lastUsedAt = lastUsedAt;
    }

    public Long getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public User getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public ApiToken withLastUsedAt(Instant lastUsedAt) {
        return new ApiToken(this.id, this.token, this.user, this.name, this.createdAt, lastUsedAt);
    }
}

