/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.security;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.MagicLinkResourceType;
import com.dedicatedcode.reitti.model.security.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class TokenUser
extends User {
    private final List<GrantedAuthority> authorities = new ArrayList();
    private final User user;
    private final MagicLinkResourceType type;
    private final Long resourceId;

    public TokenUser(User user, MagicLinkResourceType type, Long resourceId, List<String> additionalAuthorities) {
        this.user = user;
        this.type = type;
        this.resourceId = resourceId;
        this.authorities.addAll(additionalAuthorities.stream().map(SimpleGrantedAuthority::new).toList());
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Long getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    public String getPassword() {
        throw new UnsupportedOperationException("TokenUser is not a password user");
    }

    public Role getRole() {
        return Role.API_ACCESS;
    }

    public String getProfileUrl() {
        return this.user.getProfileUrl();
    }

    public boolean grantsAccessTo(MagicLinkResourceType type, Long resourceId) {
        return this.type.equals((Object)type) && (this.resourceId == null || this.resourceId.equals(resourceId));
    }
}

