/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.security;

import com.dedicatedcode.reitti.model.Role;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class User
implements UserDetails {
    private final Long id;
    private final String username;
    private final String password;
    private final String displayName;
    private final String profileUrl;
    private final String externalId;
    private final Role role;
    private final Long version;

    public User() {
        this(null, null, null, null, null, null, Role.USER, null);
    }

    public User(String username, String displayName) {
        this(null, username, null, displayName, null, null, Role.USER, null);
    }

    public User(Long id, String username, String password, String displayName, String profileUrl, String externalId, Role role, Long version) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.displayName = displayName;
        this.profileUrl = profileUrl;
        this.externalId = externalId;
        this.role = role;
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.role == null) {
            return List.of();
        }
        return List.of(new SimpleGrantedAuthority("ROLE_" + this.role.name()));
    }

    public String getPassword() {
        return this.password;
    }

    public Role getRole() {
        return this.role;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Long getVersion() {
        return this.version;
    }

    public User withPassword(String password) {
        return new User(this.id, this.username, password, this.displayName, this.profileUrl, this.externalId, this.role, this.version);
    }

    public User withDisplayName(String displayName) {
        return new User(this.id, this.username, this.password, displayName, this.profileUrl, this.externalId, this.role, this.version);
    }

    public User withVersion(Long version) {
        return new User(this.id, this.username, this.password, this.displayName, this.profileUrl, this.externalId, this.role, version);
    }

    public User withRole(Role role) {
        return new User(this.id, this.username, this.password, this.displayName, this.profileUrl, this.externalId, role, this.version);
    }

    public User withUsername(String username) {
        return new User(this.id, username, this.password, this.displayName, this.profileUrl, this.externalId, this.role, this.version);
    }

    public User withProfileUrl(String profileUrl) {
        return new User(this.id, this.username, this.password, this.displayName, profileUrl, this.externalId, this.role, this.version);
    }

    public User withExternalId(String externalId) {
        return new User(this.id, this.username, this.password, this.displayName, this.profileUrl, externalId, this.role, this.version);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + "'}";
    }
}

