/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model.security;

import com.dedicatedcode.reitti.model.Language;
import com.dedicatedcode.reitti.model.TimeDisplayMode;
import com.dedicatedcode.reitti.model.UnitSystem;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;

public class UserSettings {
    private final Long userId;
    private final boolean preferColoredMap;
    private final Language selectedLanguage;
    private final UnitSystem unitSystem;
    private final Double homeLatitude;
    private final Double homeLongitude;
    private final ZoneId timeZoneOverride;
    private final TimeDisplayMode timeDisplayMode;
    private final String customCss;
    private final Instant latestData;
    private final String color;
    private final Long version;

    public UserSettings(Long userId, boolean preferColoredMap, Language selectedLanguage, UnitSystem unitSystem, Double homeLatitude, Double homeLongitude, ZoneId timeZoneOverride, TimeDisplayMode timeDisplayMode, String customCss, Instant latestData, String color, Long version) {
        this.userId = userId;
        this.preferColoredMap = preferColoredMap;
        this.selectedLanguage = selectedLanguage;
        this.unitSystem = unitSystem;
        this.homeLatitude = homeLatitude;
        this.homeLongitude = homeLongitude;
        this.timeZoneOverride = timeZoneOverride;
        this.timeDisplayMode = timeDisplayMode;
        this.customCss = customCss;
        this.latestData = latestData;
        this.color = color;
        this.version = version;
    }

    public static UserSettings defaultSettings(Long userId) {
        return new UserSettings(userId, false, Language.EN, UnitSystem.METRIC, null, null, null, TimeDisplayMode.DEFAULT, null, null, "#f1ba63", null);
    }

    public Long getUserId() {
        return this.userId;
    }

    public boolean isPreferColoredMap() {
        return this.preferColoredMap;
    }

    public Language getSelectedLanguage() {
        return this.selectedLanguage;
    }

    public Long getVersion() {
        return this.version;
    }

    public UnitSystem getUnitSystem() {
        return this.unitSystem;
    }

    public Double getHomeLatitude() {
        return this.homeLatitude;
    }

    public Double getHomeLongitude() {
        return this.homeLongitude;
    }

    public Instant getLatestData() {
        return this.latestData;
    }

    public TimeDisplayMode getTimeDisplayMode() {
        return this.timeDisplayMode;
    }

    public ZoneId getTimeZoneOverride() {
        return this.timeZoneOverride;
    }

    public String getCustomCss() {
        return this.customCss;
    }

    public String getColor() {
        return this.color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSettings that = (UserSettings)o;
        return this.preferColoredMap == that.preferColoredMap && Objects.equals(this.userId, that.userId) && Objects.equals(this.selectedLanguage, that.selectedLanguage) && Objects.equals(this.unitSystem, that.unitSystem) && Objects.equals(this.homeLatitude, that.homeLatitude) && Objects.equals(this.homeLongitude, that.homeLongitude) && Objects.equals(this.timeZoneOverride, that.timeZoneOverride) && Objects.equals(this.timeDisplayMode, that.timeDisplayMode) && Objects.equals(this.customCss, that.customCss) && Objects.equals(this.latestData, that.latestData) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.preferColoredMap, this.selectedLanguage, this.unitSystem, this.homeLatitude, this.homeLongitude, this.timeZoneOverride, this.timeDisplayMode, this.customCss, this.latestData, this.version);
    }

    public String toString() {
        return "UserSettings{userId=" + this.userId + ", preferColoredMap=" + this.preferColoredMap + ", selectedLanguage='" + String.valueOf(this.selectedLanguage) + "', unitSystem=" + String.valueOf(this.unitSystem) + ", homeLatitude=" + this.homeLatitude + ", homeLongitude=" + this.homeLongitude + ", timeZoneOverride=" + String.valueOf(this.timeZoneOverride) + ", timeDisplayMode=" + String.valueOf(this.timeDisplayMode) + ", customCss=" + (String)(this.customCss != null ? "[" + this.customCss.length() + " chars]" : "null") + ", latestData=" + String.valueOf(this.latestData) + ", version=" + this.version + "}";
    }

    public UserSettings withVersion(long version) {
        return new UserSettings(this.userId, this.preferColoredMap, this.selectedLanguage, this.unitSystem, this.homeLatitude, this.homeLongitude, this.timeZoneOverride, this.timeDisplayMode, this.customCss, this.latestData, this.color, Long.valueOf(version));
    }
}

