/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.ApiToken;
import com.dedicatedcode.reitti.model.security.ApiTokenUsage;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApiTokenJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public ApiTokenJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Transactional(readOnly=true)
    public Optional<ApiToken> findByToken(String token) {
        String sql = "SELECT at.id, at.token, at.name, at.created_at, at.last_used_at,\n       u.id as user_id, u.username, u.password, u.display_name, u.profile_url, u.external_id, u.role, u.version as user_version\nFROM api_tokens at\nJOIN users u ON at.user_id = u.id\nWHERE at.token = ?\n";
        try {
            ApiToken apiToken = (ApiToken)this.jdbcTemplate.queryForObject(sql, (arg_0, arg_1) -> this.mapRowToApiToken(arg_0, arg_1), new Object[]{token});
            return Optional.ofNullable(apiToken);
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    @Transactional(readOnly=true)
    public List<ApiToken> findByUser(User user) {
        String sql = "SELECT at.id, at.token, at.name, at.created_at, at.last_used_at,\n       u.id as user_id, u.username, u.password, u.display_name, u.profile_url, u.external_id, u.role, u.version as user_version\nFROM api_tokens at\nJOIN users u ON at.user_id = u.id\nWHERE at.user_id = ?\nORDER BY at.created_at DESC\n";
        return this.jdbcTemplate.query(sql, (arg_0, arg_1) -> this.mapRowToApiToken(arg_0, arg_1), new Object[]{user.getId()});
    }

    @Transactional(readOnly=true)
    public Optional<ApiToken> findById(Long id) {
        String sql = "SELECT at.id, at.token, at.name, at.created_at, at.last_used_at,\n       u.id as user_id, u.username, u.password, u.display_name, u.profile_url, u.external_id, u.role, u.version as user_version\nFROM api_tokens at\nJOIN users u ON at.user_id = u.id\nWHERE at.id = ?\n";
        try {
            ApiToken apiToken = (ApiToken)this.jdbcTemplate.queryForObject(sql, (arg_0, arg_1) -> this.mapRowToApiToken(arg_0, arg_1), new Object[]{id});
            return Optional.ofNullable(apiToken);
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public ApiToken save(ApiToken apiToken) {
        if (apiToken.getId() == null) {
            return this.insert(apiToken);
        }
        return this.update(apiToken);
    }

    private ApiToken insert(ApiToken apiToken) {
        String sql = "INSERT INTO api_tokens (token, user_id, name, created_at, last_used_at) VALUES (?, ?, ?, ?, ?) RETURNING id";
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{apiToken.getToken(), apiToken.getUser().getId(), apiToken.getName(), Timestamp.from(apiToken.getCreatedAt()), apiToken.getLastUsedAt() != null ? Timestamp.from(apiToken.getLastUsedAt()) : null});
        return new ApiToken(id, apiToken.getToken(), apiToken.getUser(), apiToken.getName(), apiToken.getCreatedAt(), apiToken.getLastUsedAt());
    }

    private ApiToken update(ApiToken apiToken) {
        String sql = "UPDATE api_tokens SET token = ?, name = ?, last_used_at = ? WHERE id = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{apiToken.getToken(), apiToken.getName(), apiToken.getLastUsedAt() != null ? Timestamp.from(apiToken.getLastUsedAt()) : null, apiToken.getId()});
        if (rowsAffected == 0) {
            throw new EmptyResultDataAccessException("No ApiToken found with id: " + apiToken.getId(), 1);
        }
        return apiToken;
    }

    public void deleteById(Long id) {
        String sql = "DELETE FROM api_tokens WHERE id = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{id});
        if (rowsAffected == 0) {
            throw new EmptyResultDataAccessException("No ApiToken found with id: " + id, 1);
        }
    }

    public void delete(ApiToken apiToken) {
        this.deleteById(apiToken.getId());
    }

    @Transactional(readOnly=true)
    public boolean existsById(Long id) {
        String sql = "SELECT COUNT(*) FROM api_tokens WHERE id = ?";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{id});
        return count != null && count > 0;
    }

    @Transactional(readOnly=true)
    public long count() {
        String sql = "SELECT COUNT(*) FROM api_tokens";
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        return count != null ? count : 0L;
    }

    private ApiToken mapRowToApiToken(ResultSet rs, int rowNum) throws SQLException {
        User user = new User(Long.valueOf(rs.getLong("user_id")), rs.getString("username"), rs.getString("password"), rs.getString("display_name"), rs.getString("profile_url"), rs.getString("external_id"), Role.valueOf((String)rs.getString("role")), Long.valueOf(rs.getLong("user_version")));
        return new ApiToken(Long.valueOf(rs.getLong("id")), rs.getString("token"), user, rs.getString("name"), rs.getTimestamp("created_at").toInstant(), rs.getTimestamp("last_used_at") != null ? rs.getTimestamp("last_used_at").toInstant() : null);
    }

    private ApiTokenUsage mapRowToApiUsage(ResultSet rs, int rowNum) throws SQLException {
        return new ApiTokenUsage(rs.getString("token"), rs.getString("name"), rs.getTimestamp("at").toInstant(), rs.getString("endpoint"), rs.getString("ip"));
    }

    public List<ApiTokenUsage> getUsages(User user, int maxRows) {
        return this.jdbcTemplate.query("SELECT t.token, t.name, au.at, au.endpoint, au.ip FROM api_tokens t RIGHT JOIN api_token_usages au on t.id = au.token_id WHERE t.user_id = ? ORDER BY au.at DESC LIMIT ?", (arg_0, arg_1) -> this.mapRowToApiUsage(arg_0, arg_1), new Object[]{user.getId(), maxRows});
    }

    public void trackUsage(String token, String requestPath, String remoteIp) {
        this.jdbcTemplate.update("INSERT INTO api_token_usages(token_id, at, endpoint, ip) SELECT id, now() at time zone 'utc', ?, ? FROM api_tokens WHERE token = ?", new Object[]{requestPath, remoteIp, token});
    }

    public void deleteForUser(User user) {
        this.jdbcTemplate.update("DELETE FROM api_tokens WHERE user_id = ?", new Object[]{user.getId()});
    }
}

