/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geocoding.RemoteGeocodeService;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class GeocodeServiceJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<RemoteGeocodeService> GEOCODE_SERVICE_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public GeocodeServiceJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<RemoteGeocodeService> findByEnabledTrueOrderByLastUsedAsc() {
        String sql = "SELECT * FROM geocode_services WHERE enabled = true ORDER BY last_used ASC NULLS FIRST";
        return this.jdbcTemplate.query(sql, GEOCODE_SERVICE_ROW_MAPPER);
    }

    public List<RemoteGeocodeService> findAllByOrderByNameAsc() {
        String sql = "SELECT * FROM geocode_services ORDER BY name ASC";
        return this.jdbcTemplate.query(sql, GEOCODE_SERVICE_ROW_MAPPER);
    }

    public Optional<RemoteGeocodeService> findById(Long id) {
        String sql = "SELECT * FROM geocode_services WHERE id = ?";
        List results = this.jdbcTemplate.query(sql, GEOCODE_SERVICE_ROW_MAPPER, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((RemoteGeocodeService)results.get(0));
    }

    public RemoteGeocodeService save(RemoteGeocodeService geocodeService) {
        if (geocodeService.getId() == null) {
            String sql = "INSERT INTO geocode_services (name, url_template, enabled, error_count, last_used, last_error, version) VALUES (?, ?, ?, ?, ?, ?, ?) RETURNING id";
            Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{geocodeService.getName(), geocodeService.getUrlTemplate(), geocodeService.isEnabled(), geocodeService.getErrorCount(), geocodeService.getLastUsed() != null ? Timestamp.from(geocodeService.getLastUsed()) : null, geocodeService.getLastError() != null ? Timestamp.from(geocodeService.getLastError()) : null, geocodeService.getVersion()});
            return geocodeService.withId(id);
        }
        String sql = "UPDATE geocode_services SET name = ?, url_template = ?, enabled = ?, error_count = ?, last_used = ?, last_error = ?, version = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{geocodeService.getName(), geocodeService.getUrlTemplate(), geocodeService.isEnabled(), geocodeService.getErrorCount(), geocodeService.getLastUsed() != null ? Timestamp.from(geocodeService.getLastUsed()) : null, geocodeService.getLastError() != null ? Timestamp.from(geocodeService.getLastError()) : null, geocodeService.getVersion(), geocodeService.getId()});
        return geocodeService;
    }

    public void delete(RemoteGeocodeService geocodeService) {
        String sql = "DELETE FROM geocode_services WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{geocodeService.getId()});
    }

    public List<RemoteGeocodeService> findAll() {
        String sql = "SELECT * FROM geocode_services";
        return this.jdbcTemplate.query(sql, GEOCODE_SERVICE_ROW_MAPPER);
    }

    public boolean existsById(Long id) {
        String sql = "SELECT COUNT(*) FROM geocode_services WHERE id = ?";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{id});
        return count != null && count > 0;
    }

    public long count() {
        String sql = "SELECT COUNT(*) FROM geocode_services";
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        return count != null ? count : 0L;
    }
}

