/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.geocoding.GeocodingResponse;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.GeocodingResponseJdbcService;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeocodingResponseJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public GeocodingResponseJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void insert(GeocodingResponse geocodingResponse) {
        String sql = "INSERT INTO geocoding_response (significant_place_id, raw_data, provider_name, fetched_at, status, error_details)\nVALUES (?, to_json(?::json), ?, ?, ?, ?)\n";
        this.jdbcTemplate.update(sql, new Object[]{geocodingResponse.getSignificantPlaceId(), geocodingResponse.getRawData(), geocodingResponse.getProviderName(), Timestamp.from(geocodingResponse.getFetchedAt()), geocodingResponse.getStatus().name(), geocodingResponse.getErrorDetails()});
    }

    @Transactional(readOnly=true)
    public List<GeocodingResponse> findBySignificantPlace(SignificantPlace significantPlace) {
        String sql = "SELECT id, significant_place_id, raw_data, provider_name, fetched_at, status, error_details\nFROM geocoding_response\nWHERE significant_place_id = ?\nORDER BY fetched_at DESC\n";
        return this.jdbcTemplate.query(sql, (RowMapper)new GeocodingResponseRowMapper(), new Object[]{significantPlace.getId()});
    }

    public void deleteAllForUser(User user) {
        this.jdbcTemplate.update("DELETE FROM geocoding_response WHERE significant_place_id IN (SELECT id FROM significant_places WHERE user_id = ?)", new Object[]{user.getId()});
    }
}

