/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.integration.ImmichIntegration;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImmichIntegrationJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<ImmichIntegration> IMMICH_INTEGRATION_ROW_MAPPER = (rs, rowNum) -> new ImmichIntegration(Long.valueOf(rs.getLong("id")), rs.getString("server_url"), rs.getString("api_token"), rs.getBoolean("enabled"), rs.getTimestamp("created_at").toInstant(), rs.getTimestamp("updated_at").toInstant(), Long.valueOf(rs.getLong("version")));

    public ImmichIntegrationJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Optional<ImmichIntegration> findByUser(User user) {
        String sql = "SELECT ii.* FROM immich_integrations ii WHERE ii.user_id = ?";
        try {
            List results = this.jdbcTemplate.query(sql, IMMICH_INTEGRATION_ROW_MAPPER, new Object[]{user.getId()});
            return results.isEmpty() ? Optional.empty() : Optional.of((ImmichIntegration)results.get(0));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public ImmichIntegration save(User user, ImmichIntegration immichIntegration) {
        if (immichIntegration.getId() == null) {
            String sql = "INSERT INTO immich_integrations (user_id, server_url, api_token, enabled, created_at, updated_at, version) VALUES (?, ?, ?, ?, ?, ?, ?) RETURNING id";
            Instant now = Instant.now();
            Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), immichIntegration.getServerUrl(), immichIntegration.getApiToken(), immichIntegration.isEnabled(), Timestamp.from(now), Timestamp.from(now), immichIntegration.getVersion()});
            return immichIntegration.withId(id);
        }
        String sql = "UPDATE immich_integrations SET server_url = ?, api_token = ?, enabled = ?, updated_at = ?, version = version + 1 WHERE id = ? AND version = ?";
        Instant now = Instant.now();
        this.jdbcTemplate.update(sql, new Object[]{immichIntegration.getServerUrl(), immichIntegration.getApiToken(), immichIntegration.isEnabled(), Timestamp.from(now), immichIntegration.getId(), immichIntegration.getVersion()});
        return (ImmichIntegration)this.findById(immichIntegration.getId()).orElseThrow();
    }

    public Optional<ImmichIntegration> findById(Long id) {
        String sql = "SELECT ii.* FROM immich_integrations ii WHERE ii.id = ?";
        try {
            List results = this.jdbcTemplate.query(sql, IMMICH_INTEGRATION_ROW_MAPPER, new Object[]{id});
            return results.isEmpty() ? Optional.empty() : Optional.of((ImmichIntegration)results.get(0));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public void deleteById(Long id) {
        String sql = "DELETE FROM immich_integrations WHERE id = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{id});
        if (rowsAffected == 0) {
            throw new EmptyResultDataAccessException("No ImmichIntegration found with id: " + id, 1);
        }
    }

    public List<ImmichIntegration> findAll() {
        String sql = "SELECT ii.*FROM immich_integrations ii ";
        return this.jdbcTemplate.query(sql, IMMICH_INTEGRATION_ROW_MAPPER);
    }
}

