/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.security.MagicLinkToken;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MagicLinkJdbcService;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MagicLinkJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PasswordEncoder passwordEncoder;

    public MagicLinkJdbcService(JdbcTemplate jdbcTemplate, PasswordEncoder passwordEncoder) {
        this.jdbcTemplate = jdbcTemplate;
        this.passwordEncoder = passwordEncoder;
    }

    @CacheEvict(value={"magic-links"}, allEntries=true)
    public MagicLinkToken create(User user, MagicLinkToken token) {
        String sql = "INSERT INTO magic_link_tokens (user_id, name, token_hash, access_level, expiry_date, created_at, resource_type, resource_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\n";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Instant now = Instant.now();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(sql, new String[]{"id"});
            ps.setLong(1, user.getId());
            ps.setString(2, token.getName());
            ps.setString(3, token.getTokenHash());
            ps.setString(4, token.getAccessLevel().name());
            ps.setTimestamp(5, token.getExpiryDate() != null ? Timestamp.from(token.getExpiryDate()) : null);
            ps.setTimestamp(6, Timestamp.from(now));
            ps.setString(7, token.getResourceType().name());
            if (token.getResourceId() == null) {
                ps.setNull(8, -5);
            } else {
                ps.setLong(8, token.getResourceId());
            }
            return ps;
        }, (KeyHolder)keyHolder);
        long id = keyHolder.getKey().longValue();
        return new MagicLinkToken(Long.valueOf(id), token.getName(), token.getTokenHash(), token.getAccessLevel(), token.getExpiryDate(), token.getResourceType(), token.getResourceId(), now, null, false);
    }

    @CacheEvict(value={"magic-links"}, allEntries=true)
    public Optional<MagicLinkToken> update(MagicLinkToken updatedToken) {
        String sql = "UPDATE magic_link_tokens\nSET token_hash = ?, access_level = ?, expiry_date = ?, last_used_at = ?\nWHERE id = ?\n";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{updatedToken.getTokenHash(), updatedToken.getAccessLevel().name(), updatedToken.getExpiryDate() != null ? Timestamp.from(updatedToken.getExpiryDate()) : null, updatedToken.getLastUsed() != null ? Timestamp.from(updatedToken.getLastUsed()) : null, updatedToken.getId()});
        if (rowsAffected > 0) {
            return this.findById(updatedToken.getId());
        }
        return Optional.empty();
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"magic-links"}, key="#id")
    public Optional<MagicLinkToken> findById(long id) {
        String sql = "SELECT id, name, token_hash, access_level, expiry_date, created_at, last_used_at, resource_type, resource_id\nFROM magic_link_tokens\nWHERE id = ?\n";
        List results = this.jdbcTemplate.query(sql, (RowMapper)new MagicLinkTokenRowMapper(), new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((MagicLinkToken)results.getFirst());
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"magic-links"}, key="'hash:' + #tokenHash")
    public Optional<MagicLinkToken> findByTokenHash(String tokenHash) {
        String sql = "SELECT id, name, token_hash, access_level, expiry_date, created_at, last_used_at, resource_type, resource_id\nFROM magic_link_tokens\nWHERE token_hash = ?\n";
        List results = this.jdbcTemplate.query(sql, (RowMapper)new MagicLinkTokenRowMapper(), new Object[]{tokenHash});
        return results.isEmpty() ? Optional.empty() : Optional.of((MagicLinkToken)results.getFirst());
    }

    @Transactional(readOnly=true)
    public Optional<MagicLinkToken> findByRawToken(String rawToken) {
        String sql = "SELECT id, name, token_hash, access_level, expiry_date, created_at, last_used_at, resource_type, resource_id\nFROM magic_link_tokens\nWHERE expiry_date IS NULL OR expiry_date > ?\n";
        List activeTokens = this.jdbcTemplate.query(sql, (RowMapper)new MagicLinkTokenRowMapper(), new Object[]{Timestamp.from(Instant.now())});
        for (MagicLinkToken token : activeTokens) {
            if (!this.passwordEncoder.matches((CharSequence)rawToken, token.getTokenHash())) continue;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"magic-links"}, key="'userId:' + #tokenId")
    public Optional<Long> findUserIdByToken(long tokenId) {
        String sql = "SELECT user_id\nFROM magic_link_tokens\nWHERE id = ?\n";
        List results = this.jdbcTemplate.queryForList(sql, Long.class, new Object[]{tokenId});
        return results.isEmpty() ? Optional.empty() : Optional.of((Long)results.getFirst());
    }

    @CacheEvict(value={"magic-links"}, allEntries=true)
    public void updateLastUsed(long tokenId) {
        String sql = "UPDATE magic_link_tokens SET last_used_at = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{Timestamp.from(Instant.now()), tokenId});
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"magic-links"}, key="'user:' + #user.id")
    public List<MagicLinkToken> findByUser(User user) {
        String sql = "SELECT id, name, token_hash, access_level, expiry_date, created_at, last_used_at, resource_type, resource_id\nFROM magic_link_tokens\nWHERE user_id = ?\nORDER BY created_at DESC\n";
        return this.jdbcTemplate.query(sql, (RowMapper)new MagicLinkTokenRowMapper(), new Object[]{user.getId()});
    }

    @CacheEvict(value={"magic-links"}, allEntries=true)
    public void delete(long id) {
        String sql = "DELETE FROM magic_link_tokens WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }
}

