/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.MemoryBlockImageGallery;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class MemoryBlockImageGalleryJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper objectMapper;
    private final RowMapper<MemoryBlockImageGallery> MEMORY_BLOCK_IMAGE_GALLERY_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public MemoryBlockImageGalleryJdbcService(JdbcTemplate jdbcTemplate, ObjectMapper objectMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.objectMapper = objectMapper;
    }

    public MemoryBlockImageGallery create(MemoryBlockImageGallery gallery) {
        try {
            String imagesJson = this.objectMapper.writeValueAsString((Object)gallery.getImages());
            this.jdbcTemplate.update("INSERT INTO memory_block_image_gallery (block_id, images) VALUES (?, ?::jsonb)", new Object[]{gallery.getBlockId(), imagesJson});
            return gallery;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create MemoryBlockImageGallery", e);
        }
    }

    public MemoryBlockImageGallery update(MemoryBlockImageGallery gallery) {
        try {
            String imagesJson = this.objectMapper.writeValueAsString((Object)gallery.getImages());
            this.jdbcTemplate.update("UPDATE memory_block_image_gallery SET images = ?::jsonb WHERE block_id = ?", new Object[]{imagesJson, gallery.getBlockId()});
            return gallery;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update MemoryBlockImageGallery", e);
        }
    }

    public void delete(Long blockId) {
        this.jdbcTemplate.update("DELETE FROM memory_block_image_gallery WHERE block_id = ?", new Object[]{blockId});
    }

    public void deleteByBlockId(Long blockId) {
        this.jdbcTemplate.update("DELETE FROM memory_block_image_gallery WHERE block_id = ?", new Object[]{blockId});
    }

    public Optional<MemoryBlockImageGallery> findById(Long blockId) {
        List results = this.jdbcTemplate.query("SELECT * FROM memory_block_image_gallery WHERE block_id = ?", this.MEMORY_BLOCK_IMAGE_GALLERY_ROW_MAPPER, new Object[]{blockId});
        return results.isEmpty() ? Optional.empty() : Optional.of((MemoryBlockImageGallery)results.get(0));
    }

    public Optional<MemoryBlockImageGallery> findByBlockId(Long blockId) {
        List results = this.jdbcTemplate.query("SELECT * FROM memory_block_image_gallery WHERE block_id = ?", this.MEMORY_BLOCK_IMAGE_GALLERY_ROW_MAPPER, new Object[]{blockId});
        return results.isEmpty() ? Optional.empty() : Optional.of((MemoryBlockImageGallery)results.get(0));
    }
}

