/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.MemoryBlock;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class MemoryBlockJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<MemoryBlock> MEMORY_BLOCK_ROW_MAPPER = (rs, rowNum) -> new MemoryBlock(Long.valueOf(rs.getLong("id")), Long.valueOf(rs.getLong("memory_id")), BlockType.valueOf((String)rs.getString("block_type")), Integer.valueOf(rs.getInt("position")), Long.valueOf(rs.getLong("version")));

    public MemoryBlockJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public MemoryBlock create(MemoryBlock block) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO memory_block (memory_id, block_type, position, version) VALUES (?, ?, ?, ?)", 1);
            ps.setLong(1, block.getMemoryId());
            ps.setString(2, block.getBlockType().name());
            ps.setInt(3, block.getPosition());
            ps.setLong(4, block.getVersion());
            return ps;
        }, (KeyHolder)keyHolder);
        Long id = (Long)keyHolder.getKeys().get("id");
        return block.withId(id);
    }

    public MemoryBlock update(MemoryBlock block) {
        int updated = this.jdbcTemplate.update("UPDATE memory_block SET position = ?, version = version + 1 WHERE id = ? AND version = ?", new Object[]{block.getPosition(), block.getId(), block.getVersion()});
        if (updated == 0) {
            throw new IllegalStateException("Memory block not found or version mismatch");
        }
        return block.withVersion(Long.valueOf(block.getVersion() + 1L));
    }

    public void delete(Long blockId) {
        this.jdbcTemplate.update("DELETE FROM memory_block WHERE id = ?", new Object[]{blockId});
    }

    public Optional<MemoryBlock> findById(User user, Long id) {
        List results = this.jdbcTemplate.query("SELECT * FROM memory_block LEFT JOIN memory ON memory_block.memory_id = memory.id WHERE memory_block.id = ? AND memory.user_id = ?", MEMORY_BLOCK_ROW_MAPPER, new Object[]{id, user.getId()});
        return results.isEmpty() ? Optional.empty() : Optional.of((MemoryBlock)results.get(0));
    }

    public List<MemoryBlock> findByMemoryId(Long memoryId) {
        return this.jdbcTemplate.query("SELECT * FROM memory_block WHERE memory_id = ? ORDER BY position", MEMORY_BLOCK_ROW_MAPPER, new Object[]{memoryId});
    }

    public int getMaxPosition(Long memoryId) {
        Integer maxPosition = (Integer)this.jdbcTemplate.queryForObject("SELECT COALESCE(MAX(position), -1) FROM memory_block WHERE memory_id = ?", Integer.class, new Object[]{memoryId});
        return maxPosition != null ? maxPosition : -1;
    }

    public void deleteByMemoryId(Long memoryId) {
        this.jdbcTemplate.update("DELETE FROM memory_block WHERE memory_id = ?", new Object[]{memoryId});
    }
}

