/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.MemoryBlockText;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class MemoryBlockTextJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<MemoryBlockText> MEMORY_BLOCK_TEXT_ROW_MAPPER = (rs, rowNum) -> new MemoryBlockText(Long.valueOf(rs.getLong("block_id")), rs.getString("headline"), rs.getString("content"));

    public MemoryBlockTextJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public MemoryBlockText create(MemoryBlockText blockText) {
        this.jdbcTemplate.update("INSERT INTO memory_block_text (block_id, headline, content) VALUES (?, ?, ?)", new Object[]{blockText.getBlockId(), blockText.getHeadline(), blockText.getContent()});
        return blockText;
    }

    public MemoryBlockText update(MemoryBlockText blockText) {
        this.jdbcTemplate.update("UPDATE memory_block_text SET headline = ?, content = ? WHERE block_id = ?", new Object[]{blockText.getHeadline(), blockText.getContent(), blockText.getBlockId()});
        return blockText;
    }

    public Optional<MemoryBlockText> findByBlockId(Long blockId) {
        List results = this.jdbcTemplate.query("SELECT * FROM memory_block_text WHERE block_id = ?", MEMORY_BLOCK_TEXT_ROW_MAPPER, new Object[]{blockId});
        return results.isEmpty() ? Optional.empty() : Optional.of((MemoryBlockText)results.get(0));
    }

    public void delete(Long blockId) {
        this.jdbcTemplate.update("DELETE FROM memory_block_text WHERE block_id = ?", new Object[]{blockId});
    }
}

