/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MemoryClusterBlockRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class MemoryClusterBlockRepository {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper objectMapper;

    public MemoryClusterBlockRepository(JdbcTemplate jdbcTemplate, ObjectMapper objectMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.objectMapper = objectMapper;
    }

    public MemoryClusterBlock save(User user, MemoryClusterBlock cluster) {
        String sql = "INSERT INTO memory_block_cluster (block_id, part_ids, user_id, title, description, type) VALUES (?, ?::jsonb, ?, ?, ?, ?) ON CONFLICT (block_id) DO UPDATE SET part_ids = EXCLUDED.part_ids, title = EXCLUDED.title, description = EXCLUDED.description, type = EXCLUDED.type";
        try {
            String tripIdsJson = this.objectMapper.writeValueAsString((Object)cluster.getPartIds());
            this.jdbcTemplate.update(sql, new Object[]{cluster.getBlockId(), tripIdsJson, user.getId(), cluster.getTitle(), cluster.getDescription(), cluster.getType().name()});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save MemoryClusterBlock", e);
        }
        return cluster;
    }

    public Optional<MemoryClusterBlock> findByBlockId(User user, Long blockId) {
        String sql = "SELECT block_id, part_ids, title, description, type FROM memory_block_cluster WHERE block_id = ? AND user_id = ?";
        List results = this.jdbcTemplate.query(sql, (RowMapper)new MemoryClusterBlockRowMapper(this), new Object[]{blockId, user.getId()});
        return results.stream().findFirst();
    }

    public void deleteByBlockId(User user, Long blockId) {
        String sql = "DELETE FROM memory_block_cluster WHERE block_id = ? AND user_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{blockId, user.getId()});
    }

    public MemoryClusterBlock update(User user, MemoryClusterBlock cluster) {
        String sql = "UPDATE memory_block_cluster SET part_ids = ?::jsonb, title = ?, description = ?, type = ? WHERE block_id = ? AND user_id = ?";
        try {
            String tripIdsJson = this.objectMapper.writeValueAsString((Object)cluster.getPartIds());
            this.jdbcTemplate.update(sql, new Object[]{tripIdsJson, cluster.getTitle(), cluster.getDescription(), cluster.getType().name(), cluster.getBlockId(), user.getId()});
            return cluster;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save MemoryClusterBlock", e);
        }
    }
}

