/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.HeaderType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class MemoryJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<Memory> MEMORY_ROW_MAPPER = (rs, n) -> new Memory(Long.valueOf(rs.getLong("id")), rs.getString("title"), rs.getString("description"), rs.getTimestamp("start_date").toInstant(), rs.getTimestamp("end_date").toInstant(), HeaderType.valueOf((String)rs.getString("header_type")), rs.getString("header_image_url"), rs.getTimestamp("created_at").toInstant(), rs.getTimestamp("updated_at").toInstant(), Long.valueOf(rs.getLong("version")));

    public MemoryJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Memory create(User user, Memory memory) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO memory (user_id, title, description, start_date, end_date, header_type, header_image_url, created_at, updated_at, version) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setLong(1, user.getId());
            ps.setString(2, memory.getTitle());
            ps.setString(3, memory.getDescription());
            ps.setObject(4, Timestamp.from(memory.getStartDate()));
            ps.setObject(5, Timestamp.from(memory.getEndDate()));
            ps.setString(6, memory.getHeaderType().name());
            ps.setString(7, memory.getHeaderImageUrl());
            ps.setTimestamp(8, Timestamp.from(memory.getCreatedAt()));
            ps.setTimestamp(9, Timestamp.from(memory.getUpdatedAt()));
            ps.setLong(10, memory.getVersion());
            return ps;
        }, (KeyHolder)keyHolder);
        Long id = (Long)keyHolder.getKeys().get("id");
        return memory.withId(id);
    }

    public Memory update(User user, Memory memory) {
        int updated = this.jdbcTemplate.update("UPDATE memory SET title = ?, description = ?, start_date = ?, end_date = ?, header_type = ?, header_image_url = ?, updated_at = ?, version = version + 1 WHERE id = ? AND user_id = ? AND version = ?", new Object[]{memory.getTitle(), memory.getDescription(), Timestamp.from(memory.getStartDate()), Timestamp.from(memory.getEndDate()), memory.getHeaderType().name(), memory.getHeaderImageUrl(), Timestamp.from(memory.getUpdatedAt()), memory.getId(), user.getId(), memory.getVersion()});
        if (updated == 0) {
            throw new IllegalStateException("Memory not found or version mismatch");
        }
        return memory.withVersion(Long.valueOf(memory.getVersion() + 1L));
    }

    public void delete(User user, Long memoryId) {
        this.jdbcTemplate.update("DELETE FROM memory WHERE id = ? AND user_id = ?", new Object[]{memoryId, user.getId()});
    }

    public Optional<Memory> findById(User user, Long id) {
        List results = this.jdbcTemplate.query("SELECT * FROM memory WHERE id = ? AND user_id = ?", MEMORY_ROW_MAPPER, new Object[]{id, user.getId()});
        return results.isEmpty() ? Optional.empty() : Optional.of((Memory)results.getFirst());
    }

    public List<Memory> findAllByUser(User user) {
        return this.jdbcTemplate.query("SELECT * FROM memory WHERE user_id = ? ORDER BY created_at DESC", MEMORY_ROW_MAPPER, new Object[]{user.getId()});
    }

    public List<Memory> findAllByUser(User user, String sortBy, String sortOrder) {
        String column = this.mapSortByToColumn(sortBy);
        String order = "desc".equalsIgnoreCase(sortOrder) ? "DESC" : "ASC";
        String sql = "SELECT * FROM memory WHERE user_id = ? ORDER BY " + column + " " + order;
        return this.jdbcTemplate.query(sql, MEMORY_ROW_MAPPER, new Object[]{user.getId()});
    }

    public List<Memory> findAllByUserAndYear(User user, int year, String sortBy, String sortOrder) {
        String column = this.mapSortByToColumn(sortBy);
        String order = "desc".equalsIgnoreCase(sortOrder) ? "DESC" : "ASC";
        String sql = "SELECT * FROM memory WHERE user_id = ? AND (extract(YEAR FROM start_date) = ? OR extract(YEAR FROM end_date) = ?) ORDER BY " + column + " " + order;
        return this.jdbcTemplate.query(sql, MEMORY_ROW_MAPPER, new Object[]{user.getId(), year, year});
    }

    public List<Integer> findDistinctYears(User user) {
        String sql = "SELECT DISTINCT EXTRACT(YEAR FROM start_date) FROM memory WHERE user_id = ? ORDER BY EXTRACT(YEAR FROM start_date) DESC";
        return this.jdbcTemplate.queryForList(sql, Integer.class, new Object[]{user.getId()});
    }

    public Optional<Long> getOwnerId(Memory memory) {
        return Optional.ofNullable((Long)this.jdbcTemplate.queryForObject("SELECT user_id FROM memory WHERE id = ?", Long.class, new Object[]{memory.getId()}));
    }

    private String mapSortByToColumn(String sortBy) {
        return switch (sortBy) {
            case "title" -> "LOWER(title)";
            case "startDate" -> "start_date";
            case "createdAt" -> "created_at";
            default -> "start_date";
        };
    }
}

