/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.MemoryTrip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MemoryTripJdbcService;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class MemoryTripJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public MemoryTripJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public MemoryTrip save(User user, MemoryTrip memoryTrip, Long memoryBlockId, Long originalId) {
        String sql = "INSERT INTO memory_trips (user_id, original_id, memory_block_id, start_visit_id, end_visit_id, start_time, end_time)\nVALUES (?, ?, ?, ?, ?, ?, ?)\nRETURNING id\n";
        Long generatedId = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), originalId, memoryBlockId, memoryTrip.getStartVisit().getId(), memoryTrip.getEndVisit().getId(), Timestamp.from(memoryTrip.getStartTime()), Timestamp.from(memoryTrip.getEndTime())});
        return memoryTrip.withId(generatedId);
    }

    public List<MemoryTrip> findByMemoryBlockId(Long memoryBlockId) {
        String sql = "SELECT mt.id, mt.start_time, mt.end_time, mt.original_id,\n               sv.id as start_visit_id, sv.name as start_visit_name, sv.start_time as start_visit_start_time, sv.original_id as start_visit_original_id,\n       sv.end_time as start_visit_end_time, sv.latitude_centroid as start_visit_lat, sv.longitude_centroid as start_visit_lon, sv.timezone as start_visit_timezone,\n               ev.id as end_visit_id, ev.name as end_visit_name, ev.start_time as end_visit_start_time, ev.original_id as end_visit_original_id,\n       ev.end_time as end_visit_end_time, ev.latitude_centroid as end_visit_lat, ev.longitude_centroid as end_visit_lon, ev.timezone as end_visit_timezone\nFROM memory_trips mt\nLEFT JOIN memory_visits sv ON mt.start_visit_id = sv.id\nLEFT JOIN memory_visits ev ON mt.end_visit_id = ev.id\nWHERE mt.memory_block_id = ?\nORDER BY mt.start_time\n";
        return this.jdbcTemplate.query(sql, (RowMapper)new MemoryTripRowMapper(), new Object[]{memoryBlockId});
    }

    public List<MemoryTrip> findByUserAndMemoryId(User user, Long memoryId) {
        String sql = "SELECT mt.id, mt.start_time, mt.end_time, mt.original_id,\n               sv.id as start_visit_id, sv.name as start_visit_name, sv.start_time as start_visit_start_time,\n               sv.original_id as start_visit_original_id,\n       sv.end_time as start_visit_end_time, sv.latitude_centroid as start_visit_lat, sv.longitude_centroid as start_visit_lon, sv.timezone as start_visit_timezone,\n               ev.id as end_visit_id, ev.name as end_visit_name, ev.start_time as end_visit_start_time, ev.original_id as end_visit_original_id,\n       ev.end_time as end_visit_end_time, ev.latitude_centroid as end_visit_lat, ev.longitude_centroid as end_visit_lon, ev.timezone as end_visit_timezone\nFROM memory_trips mt\nLEFT JOIN memory_visits sv ON mt.start_visit_id = sv.id\nLEFT JOIN memory_visits ev ON mt.end_visit_id = ev.id\nJOIN memory_block mb ON mt.memory_block_id = mb.id\nWHERE mt.user_id = ? AND mb.memory_id = ?\nORDER BY mt.start_time\n";
        return this.jdbcTemplate.query(sql, (RowMapper)new MemoryTripRowMapper(), new Object[]{user.getId(), memoryId});
    }

    public void deleteByMemoryBlockId(Long memoryBlockId) {
        String sql = "DELETE FROM memory_trips WHERE memory_block_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{memoryBlockId});
    }

    public void deleteById(Long id) {
        String sql = "DELETE FROM memory_trips WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }
}

