/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.memory.MemoryVisit;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MemoryVisitJdbcService;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class MemoryVisitJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public MemoryVisitJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public MemoryVisit save(User user, MemoryVisit memoryVisit, Long memoryBlockId, Long originalId) {
        String sql = "INSERT INTO memory_visits (user_id, original_id, memory_block_id, name, start_time, end_time, latitude_centroid, longitude_centroid, timezone)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\nRETURNING id\n";
        Long generatedId = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), originalId, memoryBlockId, memoryVisit.getName(), Timestamp.from(memoryVisit.getStartTime()), Time.from(memoryVisit.getEndTime()), memoryVisit.getLatitudeCentroid(), memoryVisit.getLongitudeCentroid(), memoryVisit.getTimezone().getId()});
        return memoryVisit.withId(generatedId);
    }

    public List<MemoryVisit> findByMemoryBlockId(Long memoryBlockId) {
        String sql = "SELECT id, name, start_time, end_time, latitude_centroid, longitude_centroid, timezone\nFROM memory_visits\nWHERE memory_block_id = ?\nORDER BY start_time\n";
        return this.jdbcTemplate.query(sql, (RowMapper)new MemoryVisitRowMapper(), new Object[]{memoryBlockId});
    }

    public void deleteByMemoryBlockId(Long memoryBlockId) {
        String sql = "DELETE FROM memory_visits WHERE memory_block_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{memoryBlockId});
    }

    public void deleteById(Long id) {
        String sql = "DELETE FROM memory_visits WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{id});
    }
}

