/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.integration.OwnTracksRecorderIntegration;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class OwnTracksRecorderIntegrationJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final RowMapper<OwnTracksRecorderIntegration> rowMapper = (rs, n) -> {
        Timestamp timestamp = rs.getTimestamp("last_successful_fetch");
        Instant lastSuccessfulFetch = timestamp != null ? timestamp.toInstant() : null;
        return new OwnTracksRecorderIntegration(Long.valueOf(rs.getLong("id")), rs.getString("base_url"), rs.getString("username"), rs.getString("device_id"), rs.getString("auth_username"), rs.getString("auth_password"), rs.getBoolean("enabled"), lastSuccessfulFetch, Long.valueOf(rs.getLong("version")));
    };

    public OwnTracksRecorderIntegrationJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Optional<OwnTracksRecorderIntegration> findByUser(User user) {
        try {
            String sql = "SELECT id, base_url, username, device_id, enabled, auth_username, auth_password, last_successful_fetch, user_id, version FROM owntracks_recorder_integration WHERE user_id = ?";
            OwnTracksRecorderIntegration integration = (OwnTracksRecorderIntegration)this.jdbcTemplate.queryForObject(sql, this.rowMapper, new Object[]{user.getId()});
            return Optional.ofNullable(integration);
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public OwnTracksRecorderIntegration save(User user, OwnTracksRecorderIntegration integration) {
        String sql = "INSERT INTO owntracks_recorder_integration (base_url, username, device_id, enabled, auth_username, auth_password, last_successful_fetch, user_id, version) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(sql, 1);
            ps.setString(1, integration.getBaseUrl());
            ps.setString(2, integration.getUsername());
            ps.setString(3, integration.getDeviceId());
            ps.setBoolean(4, integration.isEnabled());
            ps.setString(5, integration.getAuthUsername());
            ps.setString(6, integration.getAuthPassword());
            if (integration.getLastSuccessfulFetch() != null) {
                ps.setTimestamp(7, Timestamp.from(integration.getLastSuccessfulFetch()));
            } else {
                ps.setTimestamp(7, null);
            }
            ps.setLong(8, user.getId());
            ps.setLong(9, 1L);
            return ps;
        }, (KeyHolder)keyHolder);
        Long id = (Long)keyHolder.getKeys().get("id");
        return integration.withId(id).withVersion(Long.valueOf(1L));
    }

    public OwnTracksRecorderIntegration update(OwnTracksRecorderIntegration integration) {
        String sql = "UPDATE owntracks_recorder_integration SET base_url = ?, username = ?, device_id = ?, enabled = ?, auth_username = ?, auth_password = ?, last_successful_fetch = ?, version = version + 1 WHERE id = ? AND version = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{integration.getBaseUrl(), integration.getUsername(), integration.getDeviceId(), integration.isEnabled(), integration.getAuthUsername(), integration.getAuthPassword(), integration.getLastSuccessfulFetch() != null ? Timestamp.from(integration.getLastSuccessfulFetch()) : null, integration.getId(), integration.getVersion()});
        if (rowsAffected == 0) {
            throw new RuntimeException("Optimistic locking failure or record not found");
        }
        return integration.withVersion(Long.valueOf(integration.getVersion() + 1L));
    }

    public void delete(OwnTracksRecorderIntegration integration) {
        String sql = "DELETE FROM owntracks_recorder_integration WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{integration.getId()});
    }
}

