/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.GeoPoint;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.stereotype.Component;

@Component
public class PointReaderWriter {
    private final WKTReader wktReader;
    private final GeometryFactory geometryFactory;

    public PointReaderWriter(GeometryFactory geometryFactory) {
        this.wktReader = new WKTReader(geometryFactory);
        this.geometryFactory = geometryFactory;
    }

    public GeoPoint read(String wkt) {
        if (wkt != null && wkt.startsWith("POINT(") && wkt.endsWith(")")) {
            try {
                String coords = wkt.substring(6, wkt.length() - 1);
                String[] parts = coords.split(" ");
                if (parts.length == 2) {
                    double longitude = Double.parseDouble(parts[0]);
                    double latitude = Double.parseDouble(parts[1]);
                    return new GeoPoint(latitude, longitude);
                }
            }
            catch (NumberFormatException coords) {
                // empty catch block
            }
        }
        try {
            Point centroid = this.wktReader.read(wkt).getCentroid();
            return new GeoPoint(centroid.getY(), centroid.getX());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String write(double x, double y) {
        return this.geometryFactory.createPoint(new Coordinate(x, y)).toString();
    }

    public String write(GeoPoint point) {
        return this.write(point.longitude(), point.latitude());
    }

    public String polygonToWkt(List<GeoPoint> polygon) {
        GeoPoint last;
        if (polygon == null || polygon.isEmpty()) {
            return null;
        }
        StringBuilder wkt = new StringBuilder("POLYGON((");
        for (int i = 0; i < polygon.size(); ++i) {
            GeoPoint point = polygon.get(i);
            wkt.append(point.longitude()).append(" ").append(point.latitude());
            if (i >= polygon.size() - 1) continue;
            wkt.append(", ");
        }
        GeoPoint first = polygon.getFirst();
        if (!first.equals((Object)(last = polygon.getLast()))) {
            wkt.append(", ").append(first.longitude()).append(" ").append(first.latitude());
        }
        wkt.append("))");
        return wkt.toString();
    }

    public List<GeoPoint> wktToPolygon(String wkt) {
        if (wkt == null || wkt.trim().isEmpty()) {
            return null;
        }
        String coordinates = wkt.substring(wkt.indexOf("((") + 2, wkt.lastIndexOf("))"));
        String[] points = coordinates.split(",");
        ArrayList<GeoPoint> polygon = new ArrayList<GeoPoint>();
        for (String point : points) {
            String[] coords = point.trim().split("\\s+");
            if (coords.length < 2) continue;
            double longitude = Double.parseDouble(coords[0]);
            double latitude = Double.parseDouble(coords[1]);
            polygon.add(GeoPoint.from((double)latitude, (double)longitude));
        }
        return polygon.isEmpty() ? null : polygon;
    }
}

