/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PreviewSignificantPlaceJdbcService;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreviewProcessedVisitJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PreviewSignificantPlaceJdbcService significantPlaceJdbcService;
    private final RowMapper<ProcessedVisit> PROCESSED_VISIT_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public PreviewProcessedVisitJdbcService(JdbcTemplate jdbcTemplate, PreviewSignificantPlaceJdbcService significantPlaceJdbcService) {
        this.jdbcTemplate = jdbcTemplate;
        this.significantPlaceJdbcService = significantPlaceJdbcService;
    }

    public Optional<ProcessedVisit> findById(Long id) {
        String sql = "SELECT pv.* FROM preview_processed_visits pv WHERE pv.id = ?";
        List results = this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((ProcessedVisit)results.get(0));
    }

    public List<ProcessedVisit> findByUserAndTimeOverlap(User user, String previewId, Instant startTime, Instant endTime) {
        String sql = "SELECT pv.* FROM preview_processed_visits pv WHERE pv.user_id = ? AND pv.start_time <= ? AND pv.end_time >= ? AND preview_id = ? ORDER BY pv.start_time";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(endTime), Timestamp.from(startTime), previewId});
    }

    public Optional<ProcessedVisit> findByUserAndId(User user, long id) {
        String sql = "SELECT pv.* FROM preview_processed_visits pv WHERE pv.user_id = ? AND pv.id = ? ORDER BY pv.start_time";
        List results = this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), id});
        return results.isEmpty() ? Optional.empty() : Optional.of((ProcessedVisit)results.get(0));
    }

    public List<ProcessedVisit> findByUserAndStartTimeBeforeEqualAndEndTimeAfterEqual(User user, String previewId, Instant endTime, Instant startTime) {
        String sql = "SELECT pv.* FROM preview_processed_visits pv WHERE pv.user_id = ? AND pv.start_time <= ? AND pv.end_time >= ? AND preview_id = ? ORDER BY start_time";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(endTime), Timestamp.from(startTime), previewId});
    }

    public void deleteAll(List<ProcessedVisit> processedVisits) {
        if (processedVisits == null || processedVisits.isEmpty()) {
            return;
        }
        List<Long> ids = processedVisits.stream().map(ProcessedVisit::getId).toList();
        String placeholders = String.join((CharSequence)",", ids.stream().map(id -> "?").toList());
        String sql = "DELETE FROM preview_processed_visits WHERE id IN (" + placeholders + ")";
        this.jdbcTemplate.update(sql, ids.toArray());
    }

    public Optional<ProcessedVisit> findByUserAndStartTimeAndEndTimeAndPlace(User user, String previewId, Instant startTime, Instant endTime, SignificantPlace place) {
        String sql = "SELECT pv.* FROM preview_processed_visits pv WHERE pv.user_id = ? AND pv.start_time = ? AND pv.end_time = ? AND pv.place_id = ? AND pv.preview_id = ? ORDER BY pv.start_time";
        List results = this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime), place.getId(), previewId});
        return Optional.ofNullable(results.isEmpty() ? null : (ProcessedVisit)results.getFirst());
    }

    public List<ProcessedVisit> bulkInsert(User user, String previewId, List<ProcessedVisit> visitsToStore) {
        if (visitsToStore.isEmpty()) {
            return new ArrayList<ProcessedVisit>();
        }
        ArrayList<ProcessedVisit> result = new ArrayList<ProcessedVisit>();
        String valuePlaceholder = "(?, ?, ?, ?, ?, ?, now())";
        String valuesPlaceholders = String.join((CharSequence)", ", Collections.nCopies(visitsToStore.size(), valuePlaceholder));
        String sql = "INSERT INTO preview_processed_visits (user_id, place_id, start_time, end_time, duration_seconds, preview_id, preview_created_at)\nVALUES " + valuesPlaceholders + " RETURNING id;";
        ArrayList<Object> batchArgs = new ArrayList<Object>();
        for (ProcessedVisit visit : visitsToStore) {
            batchArgs.add(user.getId());
            batchArgs.add(visit.getPlace().getId());
            batchArgs.add(Timestamp.from(visit.getStartTime()));
            batchArgs.add(Timestamp.from(visit.getEndTime()));
            batchArgs.add(visit.getDurationSeconds());
            batchArgs.add(previewId);
        }
        List updateCounts = this.jdbcTemplate.query(sql, (PreparedStatementSetter)new ArgumentPreparedStatementSetter(batchArgs.toArray()), (resultSet, n) -> resultSet.getLong("id"));
        updateCounts.stream().map(arg_0 -> this.findById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(result::add);
        return result;
    }
}

