/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PointReaderWriter;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Point;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreviewSignificantPlaceJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PointReaderWriter pointReaderWriter;
    private final RowMapper<SignificantPlace> significantPlaceRowMapper;

    public PreviewSignificantPlaceJdbcService(JdbcTemplate jdbcTemplate, PointReaderWriter pointReaderWriter) {
        this.jdbcTemplate = jdbcTemplate;
        this.pointReaderWriter = pointReaderWriter;
        this.significantPlaceRowMapper = (rs, n) -> new SignificantPlace(Long.valueOf(rs.getLong("id")), rs.getString("name"), rs.getString("address"), rs.getString("city"), rs.getString("country_code"), Double.valueOf(rs.getDouble("latitude_centroid")), Double.valueOf(rs.getDouble("longitude_centroid")), this.pointReaderWriter.wktToPolygon(rs.getString("polygon")), SignificantPlace.PlaceType.valueOf((String)rs.getString("type")), rs.getString("timezone") != null ? ZoneId.of(rs.getString("timezone")) : null, rs.getBoolean("geocoded"), Long.valueOf(rs.getLong("version")));
    }

    public List<SignificantPlace> findNearbyPlaces(Long userId, Point point, double distanceInMeters, String previewId) {
        String sql = "SELECT sp.id, sp.address, sp.country_code, sp.city, sp.type,\n       sp.latitude_centroid, sp.longitude_centroid, sp.name, sp.user_id,\n       ST_AsText(sp.geom) as geom, ST_AsText(sp.polygon) as polygon,\n       sp.timezone, sp.geocoded, sp.version\nFROM preview_significant_places sp\nWHERE sp.user_id = ?\nAND ST_DWithin(\n    COALESCE(sp.polygon, ST_Buffer(sp.geom, ?)),\n    ST_GeomFromText(?, '4326'),\n    0\n)\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{userId, distanceInMeters, point.toString()});
    }

    public SignificantPlace create(User user, String previewId, SignificantPlace place) {
        String sql = "INSERT INTO preview_significant_places (user_id, preview_id, name, latitude_centroid, longitude_centroid, timezone, geom, polygon) VALUES (?, ?, ?, ?, ?, ?, ST_GeomFromText(?, '4326'), CASE WHEN ?::text IS NOT NULL THEN ST_GeomFromText(?, '4326')  END) RETURNING id";
        String polygonWkt = this.pointReaderWriter.polygonToWkt(place.getPolygon());
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), previewId, place.getName(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), place.getTimezone().getId(), this.pointReaderWriter.write(place.getLongitudeCentroid().doubleValue(), place.getLatitudeCentroid().doubleValue()), polygonWkt, polygonWkt});
        return (SignificantPlace)this.findById(id).orElseThrow();
    }

    public Optional<SignificantPlace> findById(Long id) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM preview_significant_places sp\nWHERE sp.id = ?\n";
        List results = this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((SignificantPlace)results.getFirst());
    }

    public SignificantPlace update(SignificantPlace place) {
        String sql = "UPDATE preview_significant_places SET name = ?, address = ?, city = ?, country_code = ?, type = ?, latitude_centroid = ?, longitude_centroid = ?, geom = ST_GeomFromText(?, '4326'), polygon = CASE WHEN ?::text IS NOT NULL THEN ST_GeomFromText(?, '4326') ELSE NULL END, timezone = ?, geocoded = ? WHERE id = ?";
        String polygonWkt = this.pointReaderWriter.polygonToWkt(place.getPolygon());
        this.jdbcTemplate.update(sql, new Object[]{place.getName(), place.getAddress(), place.getCity(), place.getCountryCode(), place.getType().name(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), this.pointReaderWriter.write(place.getLongitudeCentroid().doubleValue(), place.getLatitudeCentroid().doubleValue()), polygonWkt, polygonWkt, place.getTimezone() != null ? place.getTimezone().getId() : null, place.isGeocoded(), place.getId()});
        return (SignificantPlace)this.findById(place.getId()).orElseThrow();
    }

    public void deleteForUser(User user) {
        this.jdbcTemplate.update("DELETE FROM preview_significant_places WHERE user_id = ?", new Object[]{user.getId()});
    }

    public void deleteForPreviewId(String previewId) {
        this.jdbcTemplate.update("DELETE FROM preview_significant_places WHERE preview_id = ?", new Object[]{previewId});
    }
}

