/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PreviewProcessedVisitJdbcService;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreviewTripJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PreviewProcessedVisitJdbcService previewProcessedVisitJdbcService;
    private final RowMapper<Trip> TRIP_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public PreviewTripJdbcService(JdbcTemplate jdbcTemplate, PreviewProcessedVisitJdbcService previewProcessedVisitJdbcService) {
        this.jdbcTemplate = jdbcTemplate;
        this.previewProcessedVisitJdbcService = previewProcessedVisitJdbcService;
    }

    public List<Trip> findByUserAndTimeOverlap(User user, String previewId, Instant startTime, Instant endTime) {
        String sql = "SELECT t.* FROM preview_trips t WHERE t.user_id = ? AND t.preview_id = ? AND ((t.start_time <= ? AND t.end_time >= ?) OR (t.start_time >= ? AND t.start_time <= ?) OR (t.end_time >= ? AND t.end_time <= ?)) ORDER BY start_time";
        return this.jdbcTemplate.query(sql, this.TRIP_ROW_MAPPER, new Object[]{user.getId(), previewId, Timestamp.from(endTime), Timestamp.from(startTime), Timestamp.from(startTime), Timestamp.from(endTime), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public List<Trip> bulkInsert(User user, String previewId, List<Trip> tripsToInsert) {
        if (tripsToInsert.isEmpty()) {
            return tripsToInsert;
        }
        String sql = "INSERT INTO preview_trips (user_id, start_visit_id, end_visit_id, start_time, end_time,\n                  duration_seconds, estimated_distance_meters, travelled_distance_meters, transport_mode_inferred, version, preview_id, preview_created_at)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, now()) ON CONFLICT DO NOTHING;\n";
        List batchArgs = tripsToInsert.stream().map(trip -> new Object[]{user.getId(), trip.getStartVisit().getId(), trip.getEndVisit().getId(), Timestamp.from(trip.getStartTime()), Timestamp.from(trip.getEndTime()), trip.getDurationSeconds(), trip.getEstimatedDistanceMeters(), trip.getTravelledDistanceMeters(), trip.getTransportModeInferred().name(), trip.getVersion(), previewId}).collect(Collectors.toList());
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return tripsToInsert;
    }

    public void deleteAll(List<Trip> existingTrips) {
        if (existingTrips == null || existingTrips.isEmpty()) {
            return;
        }
        List<Long> ids = existingTrips.stream().map(Trip::getId).toList();
        String placeholders = String.join((CharSequence)",", ids.stream().map(id -> "?").toList());
        String sql = "DELETE FROM preview_trips WHERE id IN (" + placeholders + ")";
        this.jdbcTemplate.update(sql, ids.toArray());
    }
}

