/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.Timestamp;
import java.time.Instant;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreviewVisitDetectionParametersJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<DetectionParameter> CONFIGURATION_ROW_MAPPER = (rs, n) -> {
        Long id = rs.getLong("id");
        Timestamp validSinceTimestamp = rs.getTimestamp("valid_since");
        Instant validSince = validSinceTimestamp != null ? validSinceTimestamp.toInstant() : null;
        DetectionParameter.VisitDetection visitDetection = new DetectionParameter.VisitDetection(rs.getLong("detection_minimum_stay_time_seconds"), rs.getLong("detection_max_merge_time_between_same_stay_points"));
        DetectionParameter.VisitMerging visitMerging = new DetectionParameter.VisitMerging(rs.getLong("merging_search_duration_in_hours"), rs.getLong("merging_max_merge_time_between_same_visits"), rs.getLong("merging_min_distance_between_visits"));
        DetectionParameter.LocationDensity locationDensity = new DetectionParameter.LocationDensity(rs.getDouble("density_max_interpolation_distance_meters"), (long)rs.getInt("density_max_interpolation_gap_minutes"));
        return new DetectionParameter(id, visitDetection, visitMerging, locationDensity, validSince, RecalculationState.DONE);
    };

    public PreviewVisitDetectionParametersJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public DetectionParameter findCurrent(User user, String previewId) {
        String sql = "SELECT * FROM preview_visit_detection_parameters\nWHERE user_id = ? and preview_id = ?\nORDER BY valid_since DESC NULLS LAST\n";
        return (DetectionParameter)this.jdbcTemplate.query(sql, CONFIGURATION_ROW_MAPPER, new Object[]{user.getId(), previewId}).getFirst();
    }
}

