/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessedVisitJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final SignificantPlaceJdbcService significantPlaceJdbcService;
    private final RowMapper<ProcessedVisit> PROCESSED_VISIT_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public ProcessedVisitJdbcService(JdbcTemplate jdbcTemplate, SignificantPlaceJdbcService significantPlaceJdbcService) {
        this.jdbcTemplate = jdbcTemplate;
        this.significantPlaceJdbcService = significantPlaceJdbcService;
    }

    public List<ProcessedVisit> findByUser(User user) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? ORDER BY pv.start_time";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId()});
    }

    public List<ProcessedVisit> findByUserAndTimeOverlap(User user, Instant startTime, Instant endTime) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? AND pv.start_time <= ? AND pv.end_time >= ? ORDER BY pv.start_time";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(endTime), Timestamp.from(startTime)});
    }

    public Optional<ProcessedVisit> findFirstProcessedVisitBefore(User user, Instant time) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? AND pv.end_time < ? ORDER BY pv.end_time DESC LIMIT 1";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(time)}).stream().findFirst();
    }

    public Optional<ProcessedVisit> findFirstProcessedVisitAfter(User user, Instant time) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? AND pv.start_time > ? ORDER BY pv.start_time LIMIT 1";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(time)}).stream().findFirst();
    }

    public Optional<ProcessedVisit> findByUserAndId(User user, long id) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? AND pv.id = ? ORDER BY pv.start_time";
        List results = this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), id});
        return results.isEmpty() ? Optional.empty() : Optional.of((ProcessedVisit)results.get(0));
    }

    public List<ProcessedVisit> findByUserAndStartTimeBeforeEqualAndEndTimeAfterEqual(User user, Instant endTime, Instant startTime) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.user_id = ? AND pv.start_time <= ? AND pv.end_time >= ? ORDER BY start_time";
        return this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(endTime), Timestamp.from(startTime)});
    }

    public List<Object[]> findTopPlacesByStayTimeWithLimit(User user, long limit) {
        String sql = "SELECT sp.name, SUM(pv.duration_seconds), COUNT(pv), sp.latitude_centroid, sp.longitude_centroid FROM processed_visits pv JOIN significant_places sp ON pv.place_id = sp.id WHERE pv.user_id = ? GROUP BY sp.id, sp.name, sp.latitude_centroid, sp.longitude_centroid ORDER BY SUM(pv.duration_seconds) DESC LIMIT ?";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> new Object[]{rs.getString(1), rs.getLong(2), rs.getLong(3), rs.getDouble(4), rs.getDouble(5)}, new Object[]{user.getId(), limit});
    }

    public List<Object[]> findTopPlacesByStayTimeWithLimit(User user, Instant startTime, Instant endTime, long limit) {
        String sql = "SELECT sp.name, SUM(pv.duration_seconds), COUNT(pv), sp.latitude_centroid, sp.longitude_centroid FROM processed_visits pv JOIN significant_places sp ON pv.place_id = sp.id WHERE pv.user_id = ? AND pv.start_time >= ? AND pv.end_time <= ? GROUP BY sp.id, sp.name, sp.latitude_centroid, sp.longitude_centroid ORDER BY SUM(pv.duration_seconds) DESC LIMIT ?";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> new Object[]{rs.getString(1), rs.getLong(2), rs.getLong(3), rs.getDouble(4), rs.getDouble(5)}, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime), limit});
    }

    public ProcessedVisit create(User user, ProcessedVisit visit) {
        String sql = "INSERT INTO processed_visits (user_id, start_time, end_time, duration_seconds, place_id, version) VALUES (?, ?, ?, ?, ?, 1) RETURNING id";
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), Timestamp.from(visit.getStartTime()), Timestamp.from(visit.getEndTime()), visit.getDurationSeconds(), visit.getPlace() != null ? visit.getPlace().getId() : null});
        return visit.withId(id).withVersion(1L);
    }

    public ProcessedVisit update(ProcessedVisit visit) {
        String sql = "UPDATE processed_visits SET start_time = ?, end_time = ?, duration_seconds = ?, place_id = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{Timestamp.from(visit.getStartTime()), Timestamp.from(visit.getEndTime()), visit.getDurationSeconds(), visit.getPlace().getId(), visit.getId()});
        return visit;
    }

    public Optional<ProcessedVisit> findById(Long id) {
        String sql = "SELECT pv.* FROM processed_visits pv WHERE pv.id = ?";
        List results = this.jdbcTemplate.query(sql, this.PROCESSED_VISIT_ROW_MAPPER, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((ProcessedVisit)results.get(0));
    }

    public void deleteAll(List<ProcessedVisit> processedVisits) {
        if (processedVisits == null || processedVisits.isEmpty()) {
            return;
        }
        List<Long> ids = processedVisits.stream().map(ProcessedVisit::getId).toList();
        String placeholders = String.join((CharSequence)",", ids.stream().map(id -> "?").toList());
        String sql = "DELETE FROM processed_visits WHERE id IN (" + placeholders + ")";
        this.jdbcTemplate.update(sql, ids.toArray());
    }

    public List<ProcessedVisit> bulkInsert(User user, List<ProcessedVisit> visitsToStore) {
        if (visitsToStore.isEmpty()) {
            return new ArrayList<ProcessedVisit>();
        }
        ArrayList<ProcessedVisit> result = new ArrayList<ProcessedVisit>();
        String valuePlaceholder = "(?, ?, ?, ?, ?)";
        String valuesPlaceholders = String.join((CharSequence)", ", Collections.nCopies(visitsToStore.size(), valuePlaceholder));
        String sql = "INSERT INTO processed_visits (user_id, place_id, start_time, end_time, duration_seconds)\nVALUES " + valuesPlaceholders + " RETURNING id;";
        ArrayList<Comparable<Long>> batchArgs = new ArrayList<Comparable<Long>>();
        for (ProcessedVisit visit : visitsToStore) {
            batchArgs.add(user.getId());
            batchArgs.add(visit.getPlace().getId());
            batchArgs.add(Timestamp.from(visit.getStartTime()));
            batchArgs.add(Timestamp.from(visit.getEndTime()));
            batchArgs.add(visit.getDurationSeconds());
        }
        List updateCounts = this.jdbcTemplate.query(sql, (PreparedStatementSetter)new ArgumentPreparedStatementSetter(batchArgs.toArray()), (resultSet, n) -> resultSet.getLong("id"));
        updateCounts.stream().map(arg_0 -> this.findById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(result::add);
        return result;
    }

    public void deleteAll() {
        String sql = "DELETE FROM processed_visits";
        this.jdbcTemplate.update(sql);
    }

    public void deleteAllForUser(User user) {
        this.jdbcTemplate.update("DELETE FROM processed_visits WHERE user_id = ?", new Object[]{user.getId()});
    }

    public List<LocalDate> getAffectedDays(List<SignificantPlace> places) {
        if (places.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> placeIds = places.stream().map(SignificantPlace::getId).toList();
        String placeholders = String.join((CharSequence)",", placeIds.stream().map(id -> "?").toList());
        String sql = "SELECT DISTINCT DATE(pv.start_time) AS affected_day\nFROM processed_visits pv\nWHERE pv.place_id IN (%s)\nUNION\nSELECT DISTINCT DATE(pv.end_time) AS affected_day\nFROM processed_visits pv\nWHERE pv.place_id IN (%s)\nORDER BY affected_day;\n".formatted(placeholders, placeholders);
        ArrayList<Long> params = new ArrayList<Long>();
        params.addAll(placeIds);
        params.addAll(placeIds);
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> rs.getDate("affected_day").toLocalDate(), params.toArray());
    }

    public void deleteFor(User user, List<SignificantPlace> placesToRemove) {
        Long[] idList = (Long[])placesToRemove.stream().map(SignificantPlace::getId).toList().toArray(Long[]::new);
        this.jdbcTemplate.update("DELETE FROM processed_visits WHERE user_id = ? AND place_id = ANY(?)", new Object[]{user.getId(), idList});
    }
}

