/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.ClusteredPoint;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PointReaderWriter;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RawLocationPointJdbcService {
    private static final Logger logger = LoggerFactory.getLogger(RawLocationPointJdbcService.class);
    private final JdbcTemplate jdbcTemplate;
    private final RowMapper<RawLocationPoint> rawLocationPointRowMapper;
    private final PointReaderWriter pointReaderWriter;
    private final GeometryFactory geometryFactory;

    public RawLocationPointJdbcService(JdbcTemplate jdbcTemplate, PointReaderWriter pointReaderWriter, GeometryFactory geometryFactory) {
        this.jdbcTemplate = jdbcTemplate;
        this.rawLocationPointRowMapper = (rs, n) -> new RawLocationPoint(Long.valueOf(rs.getLong("id")), rs.getTimestamp("timestamp").toInstant(), pointReaderWriter.read(rs.getString("geom")), Double.valueOf(rs.getDouble("accuracy_meters")), rs.getObject("elevation_meters", Double.class), rs.getBoolean("processed"), rs.getBoolean("synthetic"), rs.getBoolean("ignored"), Long.valueOf(rs.getLong("version")));
        this.pointReaderWriter = pointReaderWriter;
        this.geometryFactory = geometryFactory;
    }

    public List<RawLocationPoint> findByUserAndTimestampBetweenOrderByTimestampAsc(User user, Instant startTime, Instant endTime) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version FROM raw_location_points rlp WHERE rlp.user_id = ? AND rlp.timestamp >= ? AND rlp.timestamp < ? ORDER BY rlp.timestamp";
        return this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public List<RawLocationPoint> findByUserAndTimestampBetweenOrderByTimestampAsc(User user, Instant startTime, Instant endTime, boolean includeSynthetic, boolean includeIgnored) {
        StringBuilder sql = new StringBuilder().append("SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version ").append("FROM raw_location_points rlp ").append("WHERE rlp.user_id = ? ");
        if (!includeSynthetic) {
            sql.append("AND rlp.synthetic = false ");
        }
        if (!includeIgnored) {
            sql.append("AND rlp.ignored = false ");
        }
        sql.append("AND rlp.timestamp >= ? AND rlp.timestamp < ? ").append("ORDER BY rlp.timestamp");
        return this.jdbcTemplate.query(sql.toString(), this.rawLocationPointRowMapper, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public List<RawLocationPoint> findByUserAndTimestampBetweenOrderByTimestampAsc(User user, Instant startTime, Instant endTime, boolean includeSynthetic, boolean includeIgnored, int page, int pageSize) {
        StringBuilder sql = new StringBuilder().append("SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version ").append("FROM raw_location_points rlp ").append("WHERE rlp.user_id = ? ");
        if (!includeSynthetic) {
            sql.append("AND rlp.synthetic = false ");
        }
        if (!includeIgnored) {
            sql.append("AND rlp.ignored = false ");
        }
        sql.append("AND rlp.timestamp >= ? AND rlp.timestamp < ? ").append("ORDER BY rlp.timestamp").append(" OFFSET ").append(page * pageSize).append(" LIMIT ").append(pageSize);
        return this.jdbcTemplate.query(sql.toString(), this.rawLocationPointRowMapper, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public long countByUserAndTimestampBetweenOrderByTimestampAsc(User user, Instant startTime, Instant endTime, boolean includeSynthetic, boolean includeIgnored) {
        StringBuilder sql = new StringBuilder().append("SELECT COUNT(*)").append("FROM raw_location_points rlp ").append("WHERE rlp.user_id = ? ");
        if (!includeSynthetic) {
            sql.append("AND rlp.synthetic = false ");
        }
        if (!includeIgnored) {
            sql.append("AND rlp.ignored = false ");
        }
        sql.append("AND rlp.timestamp >= ? AND rlp.timestamp < ? ");
        return (Long)this.jdbcTemplate.queryForObject(sql.toString(), Long.class, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public List<RawLocationPoint> findByUserAndProcessedIsFalseOrderByTimestampWithLimit(User user, int limit, int offset) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version FROM raw_location_points rlp WHERE rlp.user_id = ? AND rlp.processed = false ORDER BY rlp.timestamp LIMIT ? OFFSET ?";
        return this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{user.getId(), limit, offset});
    }

    public List<Integer> findDistinctYearsByUser(User user) {
        String sql = "SELECT DISTINCT EXTRACT(YEAR FROM timestamp) FROM raw_location_points WHERE user_id = ? ORDER BY EXTRACT(YEAR FROM timestamp) DESC";
        return this.jdbcTemplate.queryForList(sql, Integer.class, new Object[]{user.getId()});
    }

    public RawLocationPoint create(User user, RawLocationPoint rawLocationPoint) {
        String sql = "INSERT INTO raw_location_points (user_id, timestamp, accuracy_meters, elevation_meters, geom, processed, synthetic, ignored) VALUES (?, ?, ?, ?, ST_GeomFromText(?, '4326'), ?, ?, ?) ON CONFLICT DO NOTHING RETURNING id";
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), Timestamp.from(rawLocationPoint.getTimestamp()), rawLocationPoint.getAccuracyMeters(), rawLocationPoint.getElevationMeters(), this.pointReaderWriter.write(rawLocationPoint.getGeom()), rawLocationPoint.isProcessed(), rawLocationPoint.isSynthetic(), rawLocationPoint.isIgnored()});
        return rawLocationPoint.withId(id);
    }

    public RawLocationPoint update(RawLocationPoint rawLocationPoint) {
        String sql = "UPDATE raw_location_points SET timestamp = ?, accuracy_meters = ?, elevation_meters = ?, geom = ST_GeomFromText(?, '4326'), processed = ?, synthetic = ?, ignored = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{Timestamp.from(rawLocationPoint.getTimestamp()), rawLocationPoint.getAccuracyMeters(), rawLocationPoint.getElevationMeters(), this.pointReaderWriter.write(rawLocationPoint.getGeom()), rawLocationPoint.isProcessed(), rawLocationPoint.isSynthetic(), rawLocationPoint.isIgnored(), rawLocationPoint.getId()});
        return rawLocationPoint;
    }

    public Optional<RawLocationPoint> findById(Long id) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version FROM raw_location_points rlp WHERE rlp.id = ?";
        List results = this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((RawLocationPoint)results.getFirst());
    }

    public Optional<RawLocationPoint> findLatest(User user, Instant since) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version FROM raw_location_points rlp WHERE rlp.user_id = ? AND rlp.timestamp >= ? ORDER BY rlp.timestamp LIMIT 1";
        List results = this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{user.getId(), Timestamp.from(since)});
        return results.isEmpty() ? Optional.empty() : Optional.of((RawLocationPoint)results.getFirst());
    }

    public Optional<RawLocationPoint> findLatest(User user) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version FROM raw_location_points rlp WHERE rlp.user_id = ? ORDER BY rlp.timestamp DESC LIMIT 1";
        List results = this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{user.getId()});
        return results.isEmpty() ? Optional.empty() : Optional.of((RawLocationPoint)results.getFirst());
    }

    public List<ClusteredPoint> findClusteredPointsInTimeRangeForUser(User user, Instant startTime, Instant endTime, int minimumPoints, double distanceInMeters) {
        String sql = "SELECT rlp.id, rlp.accuracy_meters, rlp.elevation_meters, rlp.timestamp, rlp.user_id, ST_AsText(rlp.geom) as geom, rlp.processed, rlp.synthetic, rlp.ignored, rlp.version , ST_ClusterDBSCAN(rlp.geom, ?, ?) over () AS cluster_id FROM raw_location_points rlp WHERE rlp.user_id = ? AND rlp.timestamp >= ? AND rlp.timestamp < ?";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> {
            RawLocationPoint point = new RawLocationPoint(Long.valueOf(rs.getLong("id")), rs.getTimestamp("timestamp").toInstant(), this.pointReaderWriter.read(rs.getString("geom")), Double.valueOf(rs.getDouble("accuracy_meters")), rs.getObject("elevation_meters", Double.class), rs.getBoolean("processed"), rs.getBoolean("synthetic"), rs.getBoolean("ignored"), Long.valueOf(rs.getLong("version")));
            Integer clusterId = rs.getObject("cluster_id", Integer.class);
            return new ClusteredPoint(point, clusterId);
        }, new Object[]{distanceInMeters, minimumPoints, user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public long count() {
        return (Long)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM raw_location_points", Long.class);
    }

    public List<RawLocationPoint> findPointsInBoxWithNeighbors(User user, Instant startTime, Instant endTime, double minLat, double maxLat, double minLon, double maxLon, int maxPoints) {
        long start = System.nanoTime();
        String countSql = "    SELECT COUNT(*)\n    FROM raw_location_points\n    WHERE user_id = ?\n      AND ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326))\n      AND timestamp >= ?::timestamp AND timestamp < ?::timestamp\n      AND ignored = false\n";
        Long relevantPointCount = (Long)this.jdbcTemplate.queryForObject(countSql, Long.class, new Object[]{minLon, minLat, maxLon, maxLat, user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
        if (relevantPointCount <= (long)maxPoints) {
            String sql = "WITH box_filtered_points AS (\n    SELECT\n        id,\n        user_id,\n        timestamp,\n        geom,\n        accuracy_meters,\n        elevation_meters,\n        processed,\n        ignored,\n        synthetic,\n        version,\n        ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)) as in_box,\n        LAG(ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)))\n            OVER (ORDER BY timestamp) as prev_in_box,\n        LEAD(ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)))\n            OVER (ORDER BY timestamp) as next_in_box\n    FROM raw_location_points\n    WHERE user_id = ?\n      AND timestamp >= ?::timestamp AND timestamp < ?::timestamp\n      AND ignored = false\n)\nSELECT\n    id,\n    user_id,\n    timestamp,\n    ST_AsText(geom) as geom,\n    accuracy_meters,\n    elevation_meters,\n    processed,\n    synthetic,\n    ignored,\n    version\nFROM box_filtered_points\nWHERE in_box = true\n   OR prev_in_box = true\n   OR next_in_box = true\nORDER BY timestamp\n";
            return this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{minLon, minLat, maxLon, maxLat, minLon, minLat, maxLon, maxLat, minLon, minLat, maxLon, maxLat, user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
        }
        Duration period = Duration.between(startTime, endTime);
        long intervalMinutes = Math.max(1L, period.toMinutes() / (long)maxPoints);
        String sql = "WITH box_filtered_points AS (\n    SELECT\n        id,\n        user_id,\n        timestamp,\n        geom,\n        accuracy_meters,\n        elevation_meters,\n        processed,\n        ignored,\n        synthetic,\n        version,\n        ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)) as in_box,\n        LAG(ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)))\n            OVER (ORDER BY timestamp) as prev_in_box,\n        LEAD(ST_Within(geom, ST_MakeEnvelope(?, ?, ?, ?, 4326)))\n            OVER (ORDER BY timestamp) as next_in_box\n    FROM raw_location_points\n    WHERE user_id = ?\n      AND timestamp >= ?::timestamp AND timestamp < ?::timestamp\n      AND ignored = false\n),\nrelevant_points AS (\n    SELECT *\n    FROM box_filtered_points\n    WHERE in_box = true\n       OR prev_in_box = true\n       OR next_in_box = true\n),\nsampled_points AS (\n    SELECT DISTINCT ON (\n        date_trunc('hour', timestamp) +\n        (EXTRACT(minute FROM timestamp)::int / %d) * interval '%d minutes'\n    )\n    id,\n    user_id,\n    timestamp,\n    geom,\n    accuracy_meters,\n    elevation_meters,\n    processed,\n    ignored,\n    synthetic,\n    version\n    FROM relevant_points\n    ORDER BY\n        date_trunc('hour', timestamp) +\n        (EXTRACT(minute FROM timestamp)::int / %d) * interval '%d minutes',\n        timestamp\n)\nSELECT\n    id,\n    user_id,\n    timestamp,\n    ST_AsText(geom) as geom,\n    accuracy_meters,\n    elevation_meters,\n    processed,\n    synthetic,\n    ignored,\n    version\nFROM sampled_points\nORDER BY timestamp\n".formatted(intervalMinutes, intervalMinutes, intervalMinutes, intervalMinutes);
        return this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{minLon, minLat, maxLon, maxLat, minLon, minLat, maxLon, maxLat, minLon, minLat, maxLon, maxLat, user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public List<RawLocationPoint> findSimplifiedRouteForPeriod(User user, Instant startTime, Instant endTime, int maxPoints) {
        Duration period = Duration.between(startTime, endTime);
        long intervalMinutes = Math.max(1L, period.toMinutes() / (long)maxPoints);
        String sql = "WITH sampled_points AS (\n    SELECT DISTINCT ON (\n        date_trunc('hour', timestamp) +\n        (EXTRACT(minute FROM timestamp)::int / %d) * interval '%d minutes'\n    )\n    id,\n    timestamp,\n    geom,\n    accuracy_meters,\n    elevation_meters,\n    processed,\n    synthetic,\n    ignored,\n    version\n    FROM raw_location_points\n    WHERE user_id = ?\n      AND timestamp >= ? AND timestamp < ?\n      AND ignored = false\n    ORDER BY\n        date_trunc('hour', timestamp) +\n        (EXTRACT(minute FROM timestamp)::int / %d) * interval '%d minutes',\n        timestamp\n)\nSELECT\n    id,\n    accuracy_meters,\n    elevation_meters,\n    timestamp,\n    ST_AsText(geom) as geom,\n    processed,\n    synthetic,\n    ignored,\n    version\nFROM sampled_points\nORDER BY timestamp\n".formatted(intervalMinutes, intervalMinutes, intervalMinutes, intervalMinutes);
        return this.jdbcTemplate.query(sql, this.rawLocationPointRowMapper, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public long countByUser(User user) {
        return (Long)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM raw_location_points WHERE user_id = ?", Long.class, new Object[]{user.getId()});
    }

    public int bulkInsert(User user, List<LocationPoint> points) {
        if (points.isEmpty()) {
            return -1;
        }
        String sql = "INSERT INTO raw_location_points (user_id, timestamp, accuracy_meters, elevation_meters, geom, processed, synthetic, ignored) VALUES (?, ?, ?, ?, CAST(? AS geometry), false, false, false) ON CONFLICT DO NOTHING;";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (LocationPoint point : points) {
            ZonedDateTime parse = ZonedDateTime.parse(point.getTimestamp());
            Timestamp timestamp = Timestamp.from(parse.toInstant());
            batchArgs.add(new Object[]{user.getId(), timestamp, point.getAccuracyMeters(), point.getElevationMeters(), this.geometryFactory.createPoint(new Coordinate(point.getLongitude().doubleValue(), point.getLatitude().doubleValue())).toString()});
        }
        int[] ints = this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return Arrays.stream(ints).sum();
    }

    /*
     * Exception decompiling
     */
    public void bulkUpdateProcessedStatus(List<RawLocationPoint> points) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteAll() {
        String sql = "DELETE FROM raw_location_points";
        this.jdbcTemplate.update(sql);
    }

    public void markAllAsUnprocessedForUser(User user) {
        String sql = "UPDATE raw_location_points SET processed = false WHERE user_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{user.getId()});
    }

    public void markAllAsUnprocessedForUser(User user, List<LocalDate> affectedDays) {
        this.jdbcTemplate.update("UPDATE raw_location_points SET processed = false WHERE user_id = ? AND date_trunc('day', timestamp) = ANY(?)", new Object[]{user.getId(), affectedDays.stream().map(d -> Timestamp.valueOf(d.atStartOfDay())).toList().toArray(new Timestamp[0])});
    }

    public void deleteAllForUser(User user) {
        String sql = "DELETE FROM raw_location_points WHERE user_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{user.getId()});
    }

    public Optional<RawLocationPoint> findProximatePoint(User user, Instant when, int maxOffsetInSeconds) {
        List result = this.findByUserAndTimestampBetweenOrderByTimestampAsc(user, when.minusSeconds(maxOffsetInSeconds / 2), when.plusSeconds(maxOffsetInSeconds / 2));
        return result.stream().findFirst();
    }

    public boolean containsData(User user, Instant start, Instant end) {
        Integer count = (Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM raw_location_points WHERE user_id = ? AND timestamp >= ? AND timestamp < ? LIMIT 1", Integer.class, new Object[]{user.getId(), start != null ? Timestamp.from(start) : Timestamp.valueOf("1970-01-01 00:00:00"), Timestamp.from(end)});
        return count != null && count > 0;
    }

    public boolean containsDataAfter(User user, Instant start) {
        Integer count = (Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM raw_location_points WHERE user_id = ? AND timestamp > ? LIMIT 1", Integer.class, new Object[]{user.getId(), Timestamp.from(start)});
        return count != null && count > 0;
    }

    public int bulkInsertSynthetic(User user, List<LocationPoint> syntheticPoints) {
        if (syntheticPoints.isEmpty()) {
            return 0;
        }
        String sql = "INSERT INTO raw_location_points (user_id, timestamp, accuracy_meters, elevation_meters, geom, processed, synthetic, ignored) VALUES (?, ?, ?, ?, CAST(? AS geometry), false, true, false) ON CONFLICT DO NOTHING;";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (LocationPoint point : syntheticPoints) {
            ZonedDateTime parse = ZonedDateTime.parse(point.getTimestamp());
            Timestamp timestamp = Timestamp.from(parse.toInstant());
            batchArgs.add(new Object[]{user.getId(), timestamp, point.getAccuracyMeters(), point.getElevationMeters(), this.geometryFactory.createPoint(new Coordinate(point.getLongitude().doubleValue(), point.getLatitude().doubleValue())).toString()});
        }
        int[] ints = this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return Arrays.stream(ints).sum();
    }

    public void deleteSyntheticPointsInRange(User user, Instant start, Instant end) {
        String sql = "DELETE FROM raw_location_points WHERE user_id = ? AND timestamp >= ? AND timestamp < ? AND synthetic = true";
        this.jdbcTemplate.update(sql, new Object[]{user.getId(), Timestamp.from(start), Timestamp.from(end)});
    }

    public void bulkUpdateIgnoredStatus(List<Long> pointIds, boolean ignored) {
        if (pointIds.isEmpty()) {
            return;
        }
        String sql = "UPDATE raw_location_points SET ignored = ?, processed = true WHERE id = ?";
        List batchArgs = pointIds.stream().map(pointId -> new Object[]{ignored, pointId}).collect(Collectors.toList());
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }
}

