/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.Page;
import com.dedicatedcode.reitti.model.PageRequest;
import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PointReaderWriter;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Point;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SignificantPlaceJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PointReaderWriter pointReaderWriter;
    private final RowMapper<SignificantPlace> significantPlaceRowMapper;

    public SignificantPlaceJdbcService(JdbcTemplate jdbcTemplate, PointReaderWriter pointReaderWriter) {
        this.jdbcTemplate = jdbcTemplate;
        this.pointReaderWriter = pointReaderWriter;
        this.significantPlaceRowMapper = (rs, n) -> new SignificantPlace(Long.valueOf(rs.getLong("id")), rs.getString("name"), rs.getString("address"), rs.getString("city"), rs.getString("country_code"), Double.valueOf(rs.getDouble("latitude_centroid")), Double.valueOf(rs.getDouble("longitude_centroid")), pointReaderWriter.wktToPolygon(rs.getString("polygon")), SignificantPlace.PlaceType.valueOf((String)rs.getString("type")), rs.getString("timezone") != null ? ZoneId.of(rs.getString("timezone")) : null, rs.getBoolean("geocoded"), Long.valueOf(rs.getLong("version")));
    }

    public Page<SignificantPlace> findByUser(User user, PageRequest pageable) {
        String countSql = "SELECT COUNT(*) FROM significant_places WHERE user_id = ?";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class, new Object[]{user.getId()});
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.country_code,\n       sp.city,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\n FROM significant_places sp\n   WHERE sp.user_id = ? ORDER BY sp.id\n LIMIT ? OFFSET ?\n";
        List content = this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{user.getId(), pageable.getPageSize(), pageable.getOffset()});
        return new Page(content, pageable, total != null ? (long)total.intValue() : 0L);
    }

    public Page<SignificantPlace> findByUserWithSearch(User user, PageRequest pageable, String search) {
        String searchCondition = search != null && !search.trim().isEmpty() ? "AND (name ILIKE ? OR address ILIKE ?)" : "";
        String countSql = "SELECT COUNT(*) FROM significant_places WHERE user_id = ? " + searchCondition;
        ArrayList<Object> countParams = new ArrayList<Object>();
        countParams.add(user.getId());
        if (search != null && !search.trim().isEmpty()) {
            countParams.add("%" + search.trim() + "%");
            countParams.add("%" + search.trim() + "%");
        }
        Integer total = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class, countParams.toArray());
        String sql = "SELECT sp.id,\n                       sp.address,\n                       sp.country_code,\n                       sp.city,\n                       sp.type,\n                       sp.latitude_centroid,\n                       sp.longitude_centroid,\n                       sp.name,\n                       sp.user_id,\n                       ST_AsText(sp.geom) as geom,\n                       ST_AsText(sp.polygon) as polygon,\n                       sp.timezone,\n                       sp.geocoded,\n                       sp.version FROM significant_places sp WHERE sp.user_id = ? " + searchCondition + " ORDER BY sp.id LIMIT ? OFFSET ? ";
        ArrayList<Number> params = new ArrayList<Number>(countParams);
        params.add(pageable.getPageSize());
        params.add(pageable.getOffset());
        List content = this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, params.toArray());
        return new Page(content, pageable, total != null ? (long)total.intValue() : 0L);
    }

    public List<SignificantPlace> findNearbyPlaces(Long userId, Point point, double distanceInDegrees) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.country_code,\n       sp.city,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.user_id = ?\nAND ST_DWithin(\n    COALESCE(sp.polygon, sp.geom),\n    ST_GeomFromText(?, '4326'),\n    ?\n)\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{userId, point.toString(), distanceInDegrees});
    }

    public List<SignificantPlace> findEnclosingPlaces(Long userId, Point point, double distanceInDegrees) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.country_code,\n       sp.city,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.user_id = ?\nAND ST_DWithin(\n    COALESCE(sp.polygon, ST_Buffer(sp.geom, ?)),\n    ST_GeomFromText(?, '4326'),\n    0\n)\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{userId, distanceInDegrees, point.toString()});
    }

    public SignificantPlace create(User user, SignificantPlace place) {
        String sql = "INSERT INTO significant_places (user_id, name, latitude_centroid, longitude_centroid, timezone, geom, polygon) VALUES (?, ?, ?, ?, ?, ST_GeomFromText(?, '4326'), CASE WHEN ?::text IS NOT NULL THEN ST_GeomFromText(?, '4326')  END) RETURNING id";
        String polygonWkt = this.pointReaderWriter.polygonToWkt(place.getPolygon());
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), place.getName(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), place.getTimezone().getId(), this.pointReaderWriter.write(place.getLongitudeCentroid().doubleValue(), place.getLatitudeCentroid().doubleValue()), polygonWkt, polygonWkt});
        return (SignificantPlace)this.findById(id).orElseThrow();
    }

    @CacheEvict(cacheNames={"significant-places"}, key="#place.id")
    public SignificantPlace update(SignificantPlace place) {
        String sql = "UPDATE significant_places SET name = ?, address = ?, city = ?, country_code = ?, type = ?, latitude_centroid = ?, longitude_centroid = ?, geom = ST_GeomFromText(?, '4326'), polygon = CASE WHEN ?::text IS NOT NULL THEN ST_GeomFromText(?, '4326')  END, timezone = ?, geocoded = ? WHERE id = ?";
        String polygonWkt = this.pointReaderWriter.polygonToWkt(place.getPolygon());
        this.jdbcTemplate.update(sql, new Object[]{place.getName(), place.getAddress(), place.getCity(), place.getCountryCode(), place.getType().name(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), this.pointReaderWriter.write(place.getLongitudeCentroid().doubleValue(), place.getLatitudeCentroid().doubleValue()), polygonWkt, polygonWkt, place.getTimezone() != null ? place.getTimezone().getId() : null, place.isGeocoded(), place.getId()});
        return (SignificantPlace)this.findById(place.getId()).orElseThrow();
    }

    @Cacheable(value={"significant-places"})
    public Optional<SignificantPlace> findById(Long id) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.id = ?\n";
        List results = this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((SignificantPlace)results.getFirst());
    }

    public boolean exists(User user, Long id) {
        return (Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM significant_places WHERE user_id = ? AND id = ?", Integer.class, new Object[]{user.getId(), id}) > 0;
    }

    public List<SignificantPlace> findNonGeocodedByUser(User user) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.user_id = ? AND sp.geocoded = false\nORDER BY sp.id\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{user.getId()});
    }

    public List<SignificantPlace> findAllByUser(User user) {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.user_id = ?\nORDER BY sp.id\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{user.getId()});
    }

    public List<SignificantPlace> findWithMissingTimezone() {
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\n WHERE sp.timezone IS NULL\n ORDER BY sp.id\n";
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper);
    }

    public void deleteForUser(User user) {
        this.jdbcTemplate.update("DELETE FROM geocoding_response WHERE significant_place_id IN (SELECT id FROM significant_places WHERE user_id = ?)", new Object[]{user.getId()});
        this.jdbcTemplate.update("DELETE FROM significant_places WHERE user_id = ?", new Object[]{user.getId()});
    }

    public void deleteForUser(User user, List<SignificantPlace> placesToRemove) {
        Long[] idList = (Long[])placesToRemove.stream().map(SignificantPlace::getId).toList().toArray(Long[]::new);
        this.jdbcTemplate.update("DELETE FROM geocoding_response WHERE significant_place_id = ANY(?)", new Object[]{idList});
        this.jdbcTemplate.update("DELETE FROM significant_places WHERE user_id = ? AND id = ANY(?)", new Object[]{user.getId(), idList});
    }

    public List<SignificantPlace> findPlacesOverlappingWithPolygon(Long userId, Long excludePlaceId, List<GeoPoint> polygon) {
        if (polygon == null || polygon.size() < 3) {
            return List.of();
        }
        String sql = "SELECT sp.id,\n       sp.address,\n       sp.city,\n       sp.country_code,\n       sp.type,\n       sp.latitude_centroid,\n       sp.longitude_centroid,\n       sp.name,\n       sp.user_id,\n       ST_AsText(sp.geom) as geom,\n       ST_AsText(sp.polygon) as polygon,\n       sp.timezone,\n       sp.geocoded,\n       sp.version\nFROM significant_places sp\nWHERE sp.user_id = ?\nAND sp.id != ?\nAND (\n    -- Check if the new polygon overlaps with existing place's polygon\n    (sp.polygon IS NOT NULL AND ST_Overlaps(sp.polygon, ST_GeomFromText(?, 4326)))\n    OR\n    -- Check if the new polygon contains the existing place's centroid\n    ST_Contains(ST_GeomFromText(?, 4326), sp.geom)\n    OR\n    -- Check if existing place's polygon contains any part of the new polygon\n    (sp.polygon IS NOT NULL AND ST_Overlaps(ST_GeomFromText(?, 4326), sp.polygon))\n)\n";
        String polygonWkt = this.pointReaderWriter.polygonToWkt(polygon);
        return this.jdbcTemplate.query(sql, this.significantPlaceRowMapper, new Object[]{userId, excludePlaceId, polygonWkt, polygonWkt, polygonWkt});
    }
}

