/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.PlaceInformationOverride;
import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.GeoUtils;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PointReaderWriter;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SignificantPlaceOverrideJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final PointReaderWriter pointReaderWriter;

    public SignificantPlaceOverrideJdbcService(JdbcTemplate jdbcTemplate, PointReaderWriter pointReaderWriter) {
        this.jdbcTemplate = jdbcTemplate;
        this.pointReaderWriter = pointReaderWriter;
    }

    public Optional<PlaceInformationOverride> findByUserAndPoint(User user, GeoPoint point) {
        double meterInDegrees = GeoUtils.metersToDegreesAtPosition((double)5.0, (double)point.latitude());
        String sql = "SELECT name, category, timezone, ST_AsText(polygon) as polygon FROM significant_places_overrides\n                                WHERE user_id = ?\n                                  AND ST_DWithin(\n                                        COALESCE(polygon, ST_Buffer(geom, ?)),\n                                        ST_GeomFromText(?, '4326'),\n                                        0\n                                    )\n                                ORDER BY ST_Distance(geom, ST_GeomFromText(?, '4326')) LIMIT 1\n";
        String pointWkt = this.pointReaderWriter.write(point);
        List override = this.jdbcTemplate.query(sql, (rs, rowNum) -> new PlaceInformationOverride(rs.getString("name"), SignificantPlace.PlaceType.valueOf((String)rs.getString("category")), ZoneId.of(rs.getString("timezone")), this.pointReaderWriter.wktToPolygon(rs.getString("polygon"))), new Object[]{user.getId(), meterInDegrees, pointWkt, pointWkt});
        return override.stream().findFirst();
    }

    public Optional<PlaceInformationOverride> findByUserAndPoint(User user, SignificantPlace place) {
        return this.findByUserAndPoint(user, new GeoPoint(place.getLatitudeCentroid().doubleValue(), place.getLongitudeCentroid().doubleValue()));
    }

    public void insertOverride(User user, SignificantPlace place) {
        GeoPoint point = new GeoPoint(place.getLatitudeCentroid().doubleValue(), place.getLongitudeCentroid().doubleValue());
        double meterInDegrees = GeoUtils.metersToDegreesAtPosition((double)5.0, (double)place.getLatitudeCentroid());
        this.jdbcTemplate.update("DELETE FROM significant_places_overrides WHERE user_id = ? AND ST_DWithin(geom, ST_GeomFromText(?, '4326'), ?)", new Object[]{user.getId(), this.pointReaderWriter.write(point), meterInDegrees});
        String polygonWkt = this.pointReaderWriter.polygonToWkt(place.getPolygon());
        String sql = "INSERT INTO significant_places_overrides (user_id, geom, name, category, timezone, polygon) VALUES (?, ST_GeomFromText(?, '4326'), ?, ?, ?, CASE WHEN ?::text IS NOT NULL THEN ST_GeomFromText(?, '4326')  END)";
        this.jdbcTemplate.update(sql, new Object[]{user.getId(), this.pointReaderWriter.write(point), place.getName(), place.getType().name(), place.getTimezone().getId(), polygonWkt, polygonWkt});
    }

    public void clear(User user, SignificantPlace place) {
        GeoPoint point = new GeoPoint(place.getLatitudeCentroid().doubleValue(), place.getLongitudeCentroid().doubleValue());
        this.jdbcTemplate.update("DELETE FROM significant_places_overrides WHERE user_id = ? AND ST_Equals(geom, ST_GeomFromText(?, '4326'))", new Object[]{user.getId(), this.pointReaderWriter.write(point)});
    }
}

