/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.TransportMode;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransportModeOverrideJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public TransportModeOverrideJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Transactional
    @CacheEvict(value={"transport-mode-overrides"}, allEntries=true)
    public void addTransportModeOverride(User user, TransportMode transportMode, Instant start, Instant end) {
        Instant middleTime = Instant.ofEpochMilli((start.toEpochMilli() + end.toEpochMilli()) / 2L);
        String deleteSql = "DELETE FROM transport_mode_overrides\nWHERE user_id = ?\nAND time BETWEEN ? AND ?\n";
        this.jdbcTemplate.update(deleteSql, new Object[]{user.getId(), Timestamp.from(start), Timestamp.from(end)});
        String insertSql = "INSERT INTO transport_mode_overrides (user_id, time, transport_mode)\nVALUES (?, ?, ?)\n";
        this.jdbcTemplate.update(insertSql, new Object[]{user.getId(), Timestamp.from(middleTime), transportMode.name()});
    }

    @Cacheable(value={"transport-mode-overrides"}, key="#user.id + '_' + #start.toEpochMilli() + '_' + #end.toEpochMilli()")
    public Optional<TransportMode> getTransportModeOverride(User user, Instant start, Instant end) {
        String sql = "SELECT transport_mode\nFROM transport_mode_overrides\nWHERE user_id = ?\nAND time BETWEEN ? AND ?\nLIMIT 1\n";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> TransportMode.valueOf((String)rs.getString("transport_mode")), new Object[]{user.getId(), Timestamp.from(start), Timestamp.from(end)}).stream().findFirst();
    }

    @Transactional
    @CacheEvict(value={"transport-mode-overrides"}, allEntries=true)
    public void deleteAllTransportModeOverrides(User user) {
        String deleteSql = "DELETE FROM transport_mode_overrides WHERE user_id = ?";
        this.jdbcTemplate.update(deleteSql, new Object[]{user.getId()});
    }
}

