/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TripJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final RowMapper<Trip> TRIP_ROW_MAPPER = new /* Unavailable Anonymous Inner Class!! */;

    public TripJdbcService(JdbcTemplate jdbcTemplate, ProcessedVisitJdbcService processedVisitJdbcService) {
        this.jdbcTemplate = jdbcTemplate;
        this.processedVisitJdbcService = processedVisitJdbcService;
    }

    public List<Trip> findByUser(User user) {
        String sql = "SELECT t.*FROM trips t WHERE t.user_id = ? ORDER BY start_time";
        return this.jdbcTemplate.query(sql, this.TRIP_ROW_MAPPER, new Object[]{user.getId()});
    }

    public Optional<Trip> findByUserAndId(User user, Long id) {
        String sql = "SELECT t.*FROM trips t WHERE t.user_id = ? AND id = ?";
        return this.jdbcTemplate.query(sql, this.TRIP_ROW_MAPPER, new Object[]{user.getId(), id}).stream().findFirst();
    }

    public List<Trip> findByUserAndTimeOverlap(User user, Instant startTime, Instant endTime) {
        String sql = "SELECT t.* FROM trips t WHERE t.user_id = ? AND ((t.start_time <= ? AND t.end_time >= ?) OR (t.start_time >= ? AND t.start_time <= ?) OR (t.end_time >= ? AND t.end_time <= ?)) ORDER BY start_time";
        return this.jdbcTemplate.query(sql, this.TRIP_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(endTime), Timestamp.from(startTime), Timestamp.from(startTime), Timestamp.from(endTime), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public boolean existsByUserAndStartTimeAndEndTime(User user, Instant startTime, Instant endTime) {
        String sql = "SELECT COUNT(*) FROM trips WHERE user_id = ? AND start_time = ? AND end_time = ?";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
        return count != null && count > 0;
    }

    public List<Object[]> findTransportStatisticsByUser(User user) {
        String sql = "SELECT transport_mode_inferred, SUM(travelled_distance_meters), SUM(duration_seconds), COUNT(*) FROM trips WHERE user_id = ? GROUP BY transport_mode_inferred ORDER BY SUM(travelled_distance_meters) DESC";
        return this.jdbcTemplate.query(sql, (rs, n) -> new Object[]{rs.getString(1), rs.getDouble(2), rs.getLong(3), rs.getLong(4)}, new Object[]{user.getId()});
    }

    public List<Object[]> findTransportStatisticsByUserAndTimeRange(User user, Instant startTime, Instant endTime) {
        String sql = "SELECT transport_mode_inferred, SUM(travelled_distance_meters), SUM(duration_seconds), COUNT(*) FROM trips WHERE user_id = ? AND start_time >= ? AND end_time <= ? GROUP BY transport_mode_inferred ORDER BY SUM(travelled_distance_meters) DESC";
        return this.jdbcTemplate.query(sql, (rs, n) -> new Object[]{rs.getString(1), rs.getDouble(2), rs.getLong(3), rs.getLong(4)}, new Object[]{user.getId(), Timestamp.from(startTime), Timestamp.from(endTime)});
    }

    public Trip create(User user, Trip trip) {
        String sql = "INSERT INTO trips (user_id, start_time, end_time, duration_seconds, travelled_distance_meters, transport_mode_inferred, start_visit_id, end_visit_id, version) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 1) RETURNING id";
        Long id = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{user.getId(), Timestamp.from(trip.getStartTime()), Timestamp.from(trip.getEndTime()), trip.getDurationSeconds(), trip.getTravelledDistanceMeters(), trip.getTransportModeInferred().name(), trip.getStartVisit() != null ? trip.getStartVisit().getId() : null, trip.getEndVisit() != null ? trip.getEndVisit().getId() : null});
        return trip.withId(id);
    }

    public Trip update(Trip trip) {
        String sql = "UPDATE trips SET start_time = ?, end_time = ?, duration_seconds = ?, travelled_distance_meters = ?, transport_mode_inferred = ?, start_visit_id = ?, end_visit_id = ?, version = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{Timestamp.from(trip.getStartTime()), Timestamp.from(trip.getEndTime()), trip.getDurationSeconds(), trip.getTravelledDistanceMeters(), trip.getTransportModeInferred().name(), trip.getStartVisit() != null ? trip.getStartVisit().getId() : null, trip.getEndVisit() != null ? trip.getEndVisit().getId() : null, trip.getVersion() + 1L, trip.getId()});
        return trip.withVersion(trip.getVersion() + 1L);
    }

    public Optional<Trip> findById(Long id) {
        String sql = "SELECT t.* FROM trips t WHERE t.id = ?";
        List results = this.jdbcTemplate.query(sql, this.TRIP_ROW_MAPPER, new Object[]{id});
        return results.isEmpty() ? Optional.empty() : Optional.of((Trip)results.getFirst());
    }

    public List<Trip> bulkInsert(User user, List<Trip> tripsToInsert) {
        if (tripsToInsert.isEmpty()) {
            return tripsToInsert;
        }
        String sql = "INSERT INTO trips (user_id, start_visit_id, end_visit_id, start_time, end_time,\n                  duration_seconds, estimated_distance_meters, travelled_distance_meters, transport_mode_inferred, version)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT DO NOTHING;\n";
        List batchArgs = tripsToInsert.stream().map(trip -> new Object[]{user.getId(), trip.getStartVisit().getId(), trip.getEndVisit().getId(), Timestamp.from(trip.getStartTime()), Timestamp.from(trip.getEndTime()), trip.getDurationSeconds(), trip.getEstimatedDistanceMeters(), trip.getTravelledDistanceMeters(), trip.getTransportModeInferred().name(), trip.getVersion()}).collect(Collectors.toList());
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return tripsToInsert;
    }

    public void deleteAll() {
        String sql = "DELETE FROM trips";
        this.jdbcTemplate.update(sql);
    }

    public void deleteAllForUser(User user) {
        String sql = "DELETE FROM trips WHERE user_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{user.getId()});
    }

    public List<Long> findIdsByUser(User user) {
        return this.jdbcTemplate.queryForList("SELECT id FROM trips WHERE user_id = ?", Long.class, new Object[]{user.getId()});
    }

    public long count() {
        return (Long)this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM trips", Long.class);
    }

    public void deleteAll(List<Trip> existingTrips) {
        if (existingTrips == null || existingTrips.isEmpty()) {
            return;
        }
        List<Long> ids = existingTrips.stream().map(Trip::getId).toList();
        String placeholders = String.join((CharSequence)",", ids.stream().map(id -> "?").toList());
        String sql = "DELETE FROM trips WHERE id IN (" + placeholders + ")";
        this.jdbcTemplate.update(sql, ids.toArray());
    }

    public void deleteFor(User user, List<SignificantPlace> placesToRemove) {
        if (placesToRemove == null || placesToRemove.isEmpty()) {
            return;
        }
        Long[] idList = (Long[])placesToRemove.stream().map(SignificantPlace::getId).toArray(Long[]::new);
        this.jdbcTemplate.update("DELETE FROM trips\n       WHERE user_id = ?\n         AND (start_visit_id IN (SELECT id FROM processed_visits WHERE place_id = ANY(?))\n          OR end_visit_id IN (SELECT id FROM processed_visits WHERE place_id = ANY(?)))\n", new Object[]{user.getId(), idList, idList});
    }
}

