/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSharing;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserSharingJdbcService {
    private final JdbcTemplate jdbcTemplate;

    public UserSharingJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Transactional(readOnly=true)
    public Set<Long> getSharedUserIds(Long sharingUserId) {
        String sql = "SELECT shared_with_user_id FROM user_sharing WHERE sharing_user_id = ?";
        return new HashSet<Long>(this.jdbcTemplate.query(sql, (rs, rowNum) -> rs.getLong("shared_with_user_id"), new Object[]{sharingUserId}));
    }

    @Transactional(readOnly=true)
    public List<UserSharing> findBySharingUser(Long sharingUserId) {
        String sql = "SELECT id, sharing_user_id, shared_with_user_id, created_at, color, version FROM user_sharing WHERE sharing_user_id = ?";
        return this.jdbcTemplate.query(sql, (arg_0, arg_1) -> this.mapRowToUserSharing(arg_0, arg_1), new Object[]{sharingUserId});
    }

    @Transactional(readOnly=true)
    public List<UserSharing> findBySharedWithUser(Long sharedWithUserId) {
        String sql = "SELECT id, sharing_user_id, shared_with_user_id, created_at, color, version FROM user_sharing WHERE shared_with_user_id = ?";
        return this.jdbcTemplate.query(sql, (arg_0, arg_1) -> this.mapRowToUserSharing(arg_0, arg_1), new Object[]{sharedWithUserId});
    }

    private void createSharing(Long sharingUserId, Long sharedWithUserId, String color) {
        String sql = "INSERT INTO user_sharing (sharing_user_id, shared_with_user_id, created_at, color, version) VALUES (?, ?, now(), ?, 1)";
        this.jdbcTemplate.update(sql, new Object[]{sharingUserId, sharedWithUserId, color});
    }

    public void create(User user, Set<UserSharing> toCreate) {
        for (UserSharing userSharing : toCreate) {
            this.createSharing(user.getId(), userSharing.getSharedWithUserId(), userSharing.getColor());
        }
    }

    private UserSharing mapRowToUserSharing(ResultSet rs, int rowNum) throws SQLException {
        return new UserSharing(Long.valueOf(rs.getLong("id")), Long.valueOf(rs.getLong("sharing_user_id")), Long.valueOf(rs.getLong("shared_with_user_id")), rs.getTimestamp("created_at").toInstant(), rs.getString("color"), Long.valueOf(rs.getLong("version")));
    }

    /*
     * Exception decompiling
     */
    public void delete(Set<UserSharing> toDelete) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dismissSharedAccess(Long sharingId, Long sharedWithUserId) {
        String sql = "DELETE FROM user_sharing WHERE id = ? AND shared_with_user_id = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{sharingId, sharedWithUserId});
        if (rowsAffected == 0) {
            throw new IllegalArgumentException("Sharing not found or access denied");
        }
    }

    public void updateSharingColor(Long sharingId, Long sharedWithUserId, String color) {
        String sql = "UPDATE user_sharing SET color = ?, version = version + 1 WHERE id = ? AND shared_with_user_id = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{color, sharingId, sharedWithUserId});
        if (rowsAffected == 0) {
            throw new IllegalArgumentException("Sharing not found or access denied");
        }
    }
}

