/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.repository;

import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class VisitDetectionParametersJdbcService {
    private final JdbcTemplate jdbcTemplate;
    private static final RowMapper<DetectionParameter> CONFIGURATION_ROW_MAPPER = (rs, n) -> {
        Long id = rs.getLong("id");
        RecalculationState recalculationState = RecalculationState.valueOf((String)rs.getString("recalculation_state"));
        Timestamp validSinceTimestamp = rs.getTimestamp("valid_since");
        Instant validSince = validSinceTimestamp != null ? validSinceTimestamp.toInstant() : null;
        DetectionParameter.VisitDetection visitDetection = new DetectionParameter.VisitDetection(rs.getLong("detection_minimum_stay_time_seconds"), rs.getLong("detection_max_merge_time_between_same_stay_points"));
        DetectionParameter.VisitMerging visitMerging = new DetectionParameter.VisitMerging(rs.getLong("merging_search_duration_in_hours"), rs.getLong("merging_max_merge_time_between_same_visits"), rs.getLong("merging_min_distance_between_visits"));
        DetectionParameter.LocationDensity locationDensity = new DetectionParameter.LocationDensity(rs.getDouble("density_max_interpolation_distance_meters"), (long)rs.getInt("density_max_interpolation_gap_minutes"));
        return new DetectionParameter(id, visitDetection, visitMerging, locationDensity, validSince, recalculationState);
    };

    public VisitDetectionParametersJdbcService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"configurations"}, key="#user.id")
    public List<DetectionParameter> findAllConfigurationsForUser(User user) {
        String sql = "SELECT * FROM visit_detection_parameters\nWHERE user_id = ?\nORDER BY valid_since DESC NULLS LAST\n";
        return this.jdbcTemplate.query(sql, CONFIGURATION_ROW_MAPPER, new Object[]{user.getId()});
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"configurations"}, key="#user.id + '_' + #id")
    public Optional<DetectionParameter> findById(Long id, User user) {
        String sql = "SELECT * FROM visit_detection_parameters\nWHERE id = ? AND user_id = ?\n";
        List results = this.jdbcTemplate.query(sql, CONFIGURATION_ROW_MAPPER, new Object[]{id, user.getId()});
        return results.stream().findFirst();
    }

    @CacheEvict(value={"configurations"}, key="#user.id")
    public void saveConfiguration(User user, DetectionParameter detectionParameter) {
        String sql = "INSERT INTO visit_detection_parameters (\n    user_id, valid_since, detection_minimum_stay_time_seconds,\n    detection_max_merge_time_between_same_stay_points, merging_search_duration_in_hours,\n    merging_max_merge_time_between_same_visits, merging_min_distance_between_visits,\n    density_max_interpolation_distance_meters, density_max_interpolation_gap_minutes, recalculation_state) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
        Timestamp validSinceTimestamp = detectionParameter.getValidSince() != null ? Timestamp.from(detectionParameter.getValidSince()) : null;
        this.jdbcTemplate.update(sql, new Object[]{user.getId(), validSinceTimestamp, detectionParameter.getVisitDetection().getMinimumStayTimeInSeconds(), detectionParameter.getVisitDetection().getMaxMergeTimeBetweenSameStayPoints(), detectionParameter.getVisitMerging().getSearchDurationInHours(), detectionParameter.getVisitMerging().getMaxMergeTimeBetweenSameVisits(), detectionParameter.getVisitMerging().getMinDistanceBetweenVisits(), detectionParameter.getLocationDensity().getMaxInterpolationDistanceMeters(), detectionParameter.getLocationDensity().getMaxInterpolationGapMinutes(), detectionParameter.getRecalculationState().name()});
    }

    @CacheEvict(value={"configurations"}, allEntries=true)
    public void updateConfiguration(DetectionParameter detectionParameter) {
        String sql = "UPDATE visit_detection_parameters SET\n    valid_since = ?,\n    detection_minimum_stay_time_seconds = ?,\n    detection_max_merge_time_between_same_stay_points = ?,\n    merging_search_duration_in_hours = ?,\n    merging_max_merge_time_between_same_visits = ?,\n    merging_min_distance_between_visits = ?,\n    density_max_interpolation_distance_meters = ?,\n    density_max_interpolation_gap_minutes = ?,\n    recalculation_state = ?\nWHERE id = ?\n";
        Timestamp validSinceTimestamp = detectionParameter.getValidSince() != null ? Timestamp.from(detectionParameter.getValidSince()) : null;
        this.jdbcTemplate.update(sql, new Object[]{validSinceTimestamp, detectionParameter.getVisitDetection().getMinimumStayTimeInSeconds(), detectionParameter.getVisitDetection().getMaxMergeTimeBetweenSameStayPoints(), detectionParameter.getVisitMerging().getSearchDurationInHours(), detectionParameter.getVisitMerging().getMaxMergeTimeBetweenSameVisits(), detectionParameter.getVisitMerging().getMinDistanceBetweenVisits(), detectionParameter.getLocationDensity().getMaxInterpolationDistanceMeters(), detectionParameter.getLocationDensity().getMaxInterpolationGapMinutes(), detectionParameter.getRecalculationState().name(), detectionParameter.getId()});
    }

    @CacheEvict(value={"configurations"}, allEntries=true)
    public void delete(Long configurationId) {
        String sql = "DELETE FROM visit_detection_parameters\nWHERE id = ? AND valid_since IS NOT NULL\n";
        this.jdbcTemplate.update(sql, new Object[]{configurationId});
    }

    public DetectionParameter findCurrent(User user, Instant instant) {
        String sql = "SELECT * FROM visit_detection_parameters\nWHERE user_id = ? AND (valid_since <= ? OR valid_since IS NULL)\nORDER BY valid_since DESC NULLS LAST\n";
        return (DetectionParameter)this.jdbcTemplate.query(sql, CONFIGURATION_ROW_MAPPER, new Object[]{user.getId(), Timestamp.from(instant)}).getFirst();
    }
}

