/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.security.ApiToken;
import com.dedicatedcode.reitti.model.security.ApiTokenUsage;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ApiTokenJdbcService;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiTokenService {
    private final ApiTokenJdbcService apiTokenJdbcService;

    @Autowired
    public ApiTokenService(ApiTokenJdbcService apiTokenJdbcService) {
        this.apiTokenJdbcService = apiTokenJdbcService;
    }

    public Optional<User> getUserByToken(String token) {
        return this.apiTokenJdbcService.findByToken(token).map(arg_0 -> this.updateLastUsed(arg_0)).map(ApiToken::getUser);
    }

    public ApiToken createToken(User user, String name) {
        ApiToken token = new ApiToken(user, name);
        return this.apiTokenJdbcService.save(token);
    }

    public void deleteToken(Long tokenId) {
        this.apiTokenJdbcService.deleteById(tokenId);
    }

    private ApiToken updateLastUsed(ApiToken token) {
        return this.apiTokenJdbcService.save(token.withLastUsedAt(Instant.now()));
    }

    public List<ApiToken> getTokensForUser(User currentUser) {
        return this.apiTokenJdbcService.findByUser(currentUser);
    }

    public List<ApiTokenUsage> getRecentUsagesForUser(User user, int maxRows) {
        return this.apiTokenJdbcService.getUsages(user, maxRows);
    }

    public void trackUsage(String token, String requestPath, String remoteIp) {
        this.apiTokenJdbcService.trackUsage(token, requestPath, remoteIp);
    }
}

