/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.service.AvatarService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class AvatarService {
    private static final Logger log = LoggerFactory.getLogger(AvatarService.class);
    private final JdbcTemplate jdbcTemplate;

    public AvatarService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Cacheable(value={"avatarData"}, key="{#userId}")
    public Optional<AvatarData> getAvatarByUserId(Long userId) {
        try {
            Map result = this.jdbcTemplate.queryForMap("SELECT mime_type, binary_data, updated_at FROM user_avatars WHERE user_id = ?", new Object[]{userId});
            String contentType = (String)result.get("mime_type");
            long updatedAt = ((Timestamp)result.get("updated_at")).getTime();
            byte[] imageData = (byte[])result.get("binary_data");
            return Optional.of(new AvatarData(contentType, imageData, updatedAt));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    public Optional<AvatarInfo> getInfo(Long userId) {
        try {
            Map result = this.jdbcTemplate.queryForMap("SELECT updated_at FROM user_avatars WHERE user_id = ?", new Object[]{userId});
            long updatedAt = ((Timestamp)result.get("updated_at")).getTime();
            return Optional.of(new AvatarInfo(updatedAt));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    @CacheEvict(value={"avatarThumbnails", "avatarData"}, key="{#userId}")
    public void updateAvatar(Long userId, String contentType, byte[] imageData) {
        this.jdbcTemplate.update("DELETE FROM user_avatars WHERE user_id = ?", new Object[]{userId});
        this.jdbcTemplate.update("INSERT INTO user_avatars (user_id, mime_type, binary_data) VALUES (?, ?, ?) ", new Object[]{userId, contentType, imageData});
    }

    @CacheEvict(value={"avatarThumbnails", "avatarData"}, key="{#userId}")
    public void deleteAvatar(Long userId) {
        this.jdbcTemplate.update("DELETE FROM user_avatars WHERE user_id = ?", new Object[]{userId});
    }

    public String generateInitials(String displayName) {
        if (displayName == null || displayName.trim().isEmpty()) {
            return "";
        }
        String trimmed = displayName.trim();
        if (trimmed.contains(" ")) {
            StringBuilder initials = new StringBuilder();
            String[] words = trimmed.split("\\s+");
            int wordCount = 0;
            for (String word : words) {
                if (word.isEmpty() || wordCount >= 2) continue;
                initials.append(Character.toUpperCase(word.charAt(0)));
                ++wordCount;
            }
            return initials.toString();
        }
        if (trimmed.length() >= 2) {
            return "" + Character.toUpperCase(trimmed.charAt(0)) + Character.toUpperCase(trimmed.charAt(1));
        }
        return "" + Character.toUpperCase(trimmed.charAt(0));
    }

    @Cacheable(value={"avatarThumbnails"}, key="{#userId, #width, #height}")
    public Optional<byte[]> getAvatarThumbnail(Long userId, int width, int height) {
        return this.getAvatarByUserId(userId).map(avatarData -> {
            byte[] byArray;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(avatarData.imageData())}).size(width, height).outputFormat(avatarData.mimeType().contains("png") ? "png" : "jpg").outputQuality(0.75).toOutputStream((OutputStream)output);
                byArray = output.toByteArray();
            }
            catch (Throwable t$) {
                try {
                    try {
                        output.close();
                    }
                    catch (Throwable x2) {
                        t$.addSuppressed(x2);
                    }
                    throw t$;
                }
                catch (IOException e) {
                    log.error("Failed to generate thumbnail for avatar of user [{}]", (Object)userId, (Object)e);
                    return null;
                }
            }
            output.close();
            return byArray;
        });
    }
}

