/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import jakarta.annotation.PostConstruct;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.iakovlev.timeshape.TimeZoneEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class GeoLocationTimezoneService {
    private static final Logger log = LoggerFactory.getLogger(GeoLocationTimezoneService.class);
    private final TimeZoneEngine engine;
    private final SignificantPlaceJdbcService significantPlaceJdbcService;
    private final JdbcTemplate jdbcTemplate;

    public GeoLocationTimezoneService(SignificantPlaceJdbcService significantPlaceJdbcService, JdbcTemplate jdbcTemplate) {
        this.significantPlaceJdbcService = significantPlaceJdbcService;
        this.jdbcTemplate = jdbcTemplate;
        this.engine = TimeZoneEngine.initialize();
    }

    @PostConstruct
    public void init() {
        List places = this.significantPlaceJdbcService.findWithMissingTimezone();
        log.info("Searching for SignificantPlaces without Timezone data. Found [{}]", (Object)places.size());
        HashMap foundTimezones = new HashMap();
        places.forEach(place -> {
            Optional zoneId = this.engine.query(place.getLatitudeCentroid().doubleValue(), place.getLongitudeCentroid().doubleValue());
            zoneId.ifPresent(id -> {
                log.debug("Zone ID [{}] found in for [{}]", id, place);
                foundTimezones.put(place.getId(), id);
            });
        });
        if (!foundTimezones.isEmpty()) {
            this.bulkUpdateTimezones(foundTimezones);
        }
    }

    private void bulkUpdateTimezones(Map<Long, ZoneId> timezoneUpdates) {
        String sql = "UPDATE significant_places SET timezone = ? WHERE id = ?";
        this.jdbcTemplate.batchUpdate(sql, timezoneUpdates.entrySet(), timezoneUpdates.size(), (ps, entry) -> {
            ps.setString(1, ((ZoneId)entry.getValue()).getId());
            ps.setLong(2, (Long)entry.getKey());
        });
        log.info("Bulk updated timezones for [{}] significant places", (Object)timezoneUpdates.size());
    }

    public Optional<ZoneId> getTimezone(SignificantPlace place) {
        Optional zoneId = this.engine.query(place.getLatitudeCentroid().doubleValue(), place.getLongitudeCentroid().doubleValue());
        if (zoneId.isEmpty()) {
            log.warn("Unable to find timezone for place [{}]", (Object)place);
        }
        return zoneId;
    }
}

